<?php
header('Content-Type: application/json');

// Replace with your actual secret key (store securely, e.g., in environment variables)
$secretKey = getenv('REWARD_SECRET_KEY') ?: 'v5rcdz4hnIcYfiP7j6ErLoGl9n8kdZ1R';

// Get request data
$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['rewardId'], $input['userId'], $input['projectId'], $input['amount'], $input['hash'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid request data']);
    exit;
}

$rewardId = $input['rewardId'];
$userId = $input['userId'];
$projectId = $input['projectId'];
$amount = $input['amount'];
$receivedHash = $input['hash'];

// Step 1: Verify the hash
$expectedHash = hash('sha1', "{$userId}:{$projectId}:{$rewardId}:{$amount}:{$secretKey}");

if ($receivedHash !== $expectedHash) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Invalid hash']);
    exit;
}

// Step 2: Perform additional eligibility checks (customize as needed)
// Example: Check if user exists in your system (pseudo-code)
// $userExists = checkUserExists($userId); // Implement your logic
// if (!$userExists) {
//     http_response_code(403);
//     echo json_encode(['success' => false, 'error' => 'User not found']);
//     exit;
// }

// Example: Check if reward hasn't already been claimed (pseudo-code)
// $rewardClaimed = checkRewardClaimed($rewardId); // Implement your logic
// if ($rewardClaimed) {
//     http_response_code(403);
//     echo json_encode(['success' => false, 'error' => 'Reward already claimed']);
//     exit;
// }

// Step 3: Generate confirmation hash
$confirmationHash = hash('sha1', "{$rewardId}:{$userId}:{$projectId}:{$amount}:confirm:{$secretKey}");

// Step 4: Update user balance in your system (pseudo-code)
// updateUserBalance($userId, $amount); // Implement your logic

// Step 5: Return confirmation hash
echo json_encode([
    'success' => true,
    'confirmationHash' => $confirmationHash
]);
?>