<?php
header('Content-Type: application/json');

$host = 'localhost';
$db   = 'sbabewrx_scratch';
$user = 'sbabewrx_scratch';
$pass = 'sbabewrx_scratch';

if (!isset($_GET['user_id']) || !isset($_GET['inviter_id'])) {
    echo json_encode(['ok' => false, 'message' => 'Missing user_id or inviter_id']);
    exit;
}

$user_id = $_GET['user_id'];
$inviter_id = $_GET['inviter_id'];

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->prepare("SELECT user_id FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(['ok' => false, 'message' => 'User is not registered']);
        exit;
    }

    $stmt = $pdo->prepare("SELECT reflist FROM users WHERE user_id = ?");
    $stmt->execute([$inviter_id]);
    $inviter = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$inviter || !$inviter['reflist']) {
        echo json_encode(['ok' => false, 'message' => 'User registered through other users invite link.']);
        exit;
    }

    $reflist = json_decode($inviter['reflist'], true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['ok' => false, 'message' => 'Invalid reflist format.']);
        exit;
    }

    $found = false;
    foreach ($reflist as $ref) {
        if (isset($ref['user_id']) && $ref['user_id'] == $user_id) {
            $found = true;
            break;
        }
    }

    if ($found) {
        echo json_encode(['ok' => true, 'message' => 'User is registered using your link']);
    } else {
        echo json_encode(['ok' => false, 'message' => 'User registered through other users invite link.']);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'message' => 'Internal server error']);
}
