<?php
$botToken = "8018579988:AAEbHhupWzm2UsmHP0tRxK1zjblE-QWCCpA";
$admin_ids = [7503010309, 7378059553]; // Admin IDs
$apiUrl = "https://api.telegram.org/bot$botToken/";

$dsn = "mysql:host=localhost;dbname=sbabewrx_scratch;charset=utf8mb4";
$username = "sbabewrx_scratch";
$password = "sbabewrx_scratch";

// ✅ Database connection
try {
    $pdo = new PDO($dsn, $username, $password, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
} catch (PDOException $e) {
    die("DB Connection failed: " . $e->getMessage());
}

// ✅ Get update
$update = json_decode(file_get_contents("php://input"), true);

// Check if callback query (button click)
if (isset($update['callback_query'])) {
    $callback_id = $update['callback_query']['id'];
    $callback_data = $update['callback_query']['data'];
    $from_id = $update['callback_query']['from']['id'];
    $chat_id = $update['callback_query']['message']['chat']['id'];

    if (!in_array($from_id, $admin_ids)) {
        answerCallback($callback_id, "❌ Not authorized!");
        exit;
    }

    if ($callback_data === 'confirm_clear') {
        $pdo->query("UPDATE users SET balance = 0");
        answerCallback($callback_id, "✅ All balances cleared!");
        editMessage($chat_id, $update['callback_query']['message']['message_id'], "✅ All user balances have been cleared.");
    }
    exit;
}

// If normal message
if (!isset($update['message'])) {
    exit;
}

$chat_id = $update['message']['chat']['id'];
$user_id = $update['message']['from']['id'];
$text = trim($update['message']['text']);

// ✅ Only admins can use commands
if (!in_array($user_id, $admin_ids)) {
    sendMessage($chat_id, "❌ You are not authorized to use this command.");
    exit;
}

// ✅ /start
if ($text === "/start") {
    $msg = "✅ <b>Welcome Admin!</b>\n\nCommands:\n";
    $msg .= "➡ <code>/ban user_id1,user_id2</code> → Ban users\n";
    $msg .= "➡ <code>/bal</code> → Stats & Top users\n";
    $msg .= "➡ <code>/clear</code> → Clear all balances\n";
    $msg .= "➡ <code>/calc mega 1000000</code> → Convert MEGA to DOGE & USDT\n";
    $msg .= "➡ <code>/calc doge 100</code> → Convert DOGE to MEGA & USDT";
    sendMessage($chat_id, $msg, 'HTML');
    exit;
}

// ✅ /clear
if ($text === "/clear") {
    $keyboard = [
        'inline_keyboard' => [
            [['text' => "✅ Confirm Clear All", 'callback_data' => "confirm_clear"]]
        ]
    ];
    sendMessage($chat_id, "⚠ Are you sure you want to clear all user balances?", 'HTML', $keyboard);
    exit;
}

// ✅ /ban
if (strpos($text, "/ban") === 0) {
    $parts = explode(" ", $text, 2);
    if (count($parts) < 2 || empty($parts[1])) {
        sendMessage($chat_id, "⚠ Provide user IDs separated by commas.\nExample: /ban 12345,67890");
        exit;
    }

    $user_ids = array_map('trim', explode(",", $parts[1]));
    $user_ids = array_filter($user_ids, 'is_numeric');

    if (empty($user_ids)) {
        sendMessage($chat_id, "❌ No valid user IDs found.");
        exit;
    }

    $stmt = $pdo->prepare("INSERT INTO ban_users (user_id) VALUES (:user_id)");
    $banned = [];
    foreach ($user_ids as $id) {
        try {
            $stmt->execute(['user_id' => $id]);
            $banned[] = $id;
        } catch (PDOException $e) {}
    }

    if (!empty($banned)) {
        sendMessage($chat_id, "✅ Banned: " . implode(", ", $banned));
    } else {
        sendMessage($chat_id, "❌ No users banned.");
    }
    exit;
}

// ✅ /bal
if (strpos($text, "/bal") === 0) {
    $totalUsers = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $totalBalance = (float)$pdo->query("SELECT SUM(balance) FROM users")->fetchColumn();

    // Get live DOGE → USDT
    $dogeToUsdtRate = getLiveRate();

    $megaToDogeRate = 0.00003; // 1 MEGA = 0.00003 DOGE
    $totalBalanceDOGE = $totalBalance * $megaToDogeRate;
    $totalBalanceUSDT = $totalBalanceDOGE * $dogeToUsdtRate;

    $richUsers = $pdo->query("SELECT name, user_id, balance FROM users ORDER BY balance DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);

    $message = "📊 <b>Mega Platform Stats</b> 📊\n═══════\n";
    $message .= "👥 <b>Total Users:</b> " . number_format($totalUsers) . "\n";
    $message .= "💰 <b>Total Balance:</b> " . number_format($totalBalance, 2) . " MEGA\n";
    $message .= "💎 <b>In DOGE:</b> " . number_format($totalBalanceDOGE, 6) . " DOGE\n";
    $message .= "💵 <b>In USDT:</b> $" . number_format($totalBalanceUSDT, 2) . "\n";
    $message .= "═══════\n🏆 <b>Top 5 Richest Users</b> 🏆\n";

    foreach ($richUsers as $index => $u) {
        $rank = $index + 1;
        $balance = number_format($u['balance'], 2);
        $balanceDOGE = $u['balance'] * $megaToDogeRate;
        $link = "tg://user?id={$u['user_id']}";
        $message .= "$rank. {$u['name']} — <a href=\"$link\"><code>{$u['user_id']}</code></a> — <b>$balance MEGA</b> (~" . number_format($balanceDOGE, 6) . " DOGE)\n";
    }

    $message .= "═══════\n🔄 <i>Stats updated as of " . date('F j, Y, g:i A T') . "</i>";
    sendMessage($chat_id, $message, 'HTML');
    exit;
}

// ✅ /calc
if (strpos($text, "/calc") === 0) {
    $parts = explode(" ", $text);
    if (count($parts) < 3) {
        sendMessage($chat_id, "⚠ Usage:\n/calc mega 1000000\n/calc doge 100");
        exit;
    }

    $type = strtolower($parts[1]);
    $amount = (float)$parts[2];

    if ($amount <= 0) {
        sendMessage($chat_id, "⚠ Please provide a valid amount.");
        exit;
    }

    $dogeToUsdtRate = getLiveRate();
    $megaToDogeRate = 0.00003; // fixed

    if ($type === "mega") {
        $doge = $amount * $megaToDogeRate;
        $usdt = $doge * $dogeToUsdtRate;
        sendMessage($chat_id, "💰 <b>$amount MEGA</b> ≈ " . number_format($doge, 6) . " DOGE ≈ $" . number_format($usdt, 2) . " USDT", "HTML");
    } elseif ($type === "doge") {
        $mega = $amount / $megaToDogeRate;
        $usdt = $amount * $dogeToUsdtRate;
        sendMessage($chat_id, "💎 <b>$amount DOGE</b> ≈ " . number_format($mega, 2) . " MEGA ≈ $" . number_format($usdt, 2) . " USDT", "HTML");
    } else {
        sendMessage($chat_id, "⚠ Invalid type. Use <code>mega</code> or <code>doge</code>.");
    }
    exit;
}

// ✅ Helper Functions
function sendMessage($chat_id, $text, $parse_mode = null, $keyboard = null) {
    global $apiUrl;
    $params = ['chat_id' => $chat_id, 'text' => $text];
    if ($parse_mode) $params['parse_mode'] = $parse_mode;
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard);
    file_get_contents($apiUrl . "sendMessage?" . http_build_query($params));
}

function editMessage($chat_id, $message_id, $text) {
    global $apiUrl;
    file_get_contents($apiUrl . "editMessageText?" . http_build_query([
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ]));
}

function answerCallback($callback_id, $text) {
    global $apiUrl;
    file_get_contents($apiUrl . "answerCallbackQuery?" . http_build_query([
        'callback_query_id' => $callback_id,
        'text' => $text,
        'show_alert' => false
    ]));
}

// ✅ Get live DOGE price in USDT from CoinGecko
function getLiveRate() {
    $url = "https://api.coingecko.com/api/v3/simple/price?ids=dogecoin&vs_currencies=usd";
    $res = @file_get_contents($url);
    if ($res) {
        $json = json_decode($res, true);
        if (isset($json['dogecoin']['usd'])) {
            return (float)$json['dogecoin']['usd'];
        }
    }
    return 0.28; // fallback
}
?>