<?php
require_once 'Telegram.php';

// Initialize the bot
Bot::init('7899884620:AAG11AczPG-a7BFKSk0VpHYH04w7SNZubhY');

// Database connection
$db_host = 'localhost';
$db_name = 'sbabewrx_scratch';
$db_user = 'sbabewrx_scratch';
$db_pass = 'sbabewrx_scratch';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    error_log('Database connection error: ' . $e->getMessage());
    http_response_code(200);
    exit;
}

define('ADMIN_CHAT_ID', '7503010309');

$update = Bot::$update;
$command = Bot::$command ?? null;

// Log raw update for debugging
error_log("Webhook received: " . json_encode($update));

// Handle pre-checkout query (approve payment)
if (!empty($update['pre_checkout_query'])) {
    $query = $update['pre_checkout_query'];

    Bot::answerPreCheckoutQuery([
        'pre_checkout_query_id' => $query['id'],
        'ok' => true
    ]);

    http_response_code(200);
    exit;
}

// ✅ Handle successful payment
if (!empty($update['message']['successful_payment'])) {
    $payment = $update['message']['successful_payment'];
    $fromId = $update['message']['from']['id'];
    $fromName = $update['message']['from']['first_name'] ?? 'User';

    $total_amount = $payment['total_amount']; // In Stars (XTR)
    $payload = $payment['invoice_payload'];   // user_id|keys|timestamp

    // Parse payload
    list($user_id, $keys, $timestamp) = explode('|', $payload);

    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE users SET `key` = `key` + ? WHERE user_id = ?");
        $stmt->execute([$keys, $user_id]);
        $pdo->commit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Failed to update keys for user $user_id: " . $e->getMessage());
        http_response_code(200);
        exit;
    }

    // Send user confirmation
    Bot::sendMessage([
        'chat_id' => $fromId,
        'text' => "✅ Payment successful!\n💰 You purchased $keys key(s).\n🔑 They have been added to your account.",
        'parse_mode' => 'HTML'
    ]);

    // Notify admin
    Bot::sendMessage([
        'chat_id' => ADMIN_CHAT_ID,
        'text' => "📥 <b>New Key Purchase</b>\n\n👤 <a href='tg://user?id=$fromId'>$fromName</a>\n💰 Stars Paid: $total_amount\n🔑 Keys Credited: $keys",
        'parse_mode' => 'HTML'
    ]);

    http_response_code(200);
    exit;
}

// Handle /start or other commands here if needed...
http_response_code(200);