
<?php
header('Content-Type: application/json');

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Get user_id from parameters
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$daily_limit = 50; // Max 50 keys per day

if ($user_id <= 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid user ID'
    ]);
    exit;
}

// Start transaction
$conn->begin_transaction();
try {
    // Get current date
    $today = date('Y-m-d');

    // 1. Fetch current reflist, key, and ref_bonus_key_records
    $query = "SELECT reflist, `key`, ref_bonus_key_records FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    if (!$row) {
        throw new Exception("User not found");
    }

    $reflist = $row['reflist'] ? json_decode($row['reflist'], true) : [];
    $current_key = $row['key'] ?? 0;
    $key_records = $row['ref_bonus_key_records'] ? json_decode($row['ref_bonus_key_records'], true) : [];

    if (!is_array($reflist) || !is_array($key_records)) {
        $reflist = [];
        $key_records = [];
    }

    // 2. Check today's claimed keys
    $today_keys = 0;
    foreach ($key_records as $record) {
        if ($record['date'] === $today) {
            $today_keys = $record['amount'];
            break;
        }
    }

    if ($today_keys >= $daily_limit) {
        throw new Exception("Daily key claim limit ($daily_limit) reached");
    }

    // 3. Count unclaimed invitations from today
    $today_invitations = 0;
    $updated_reflist = [];
    foreach ($reflist as $entry) {
        $entry_date = substr($entry['date'], 0, 10); // Extract date part (YYYY-MM-DD)
        $is_unclaimed = !isset($entry['key_claimed']) || $entry['key_claimed'] !== true;
        if ($entry_date === $today && $is_unclaimed) {
            $today_invitations++;
            $entry['key_claimed'] = true; // Mark as claimed
        }
        $updated_reflist[] = $entry;
    }

    // 4. Calculate keys to award (up to remaining daily limit)
    $remaining_limit = $daily_limit - $today_keys;
    $keys_to_award = min($today_invitations, $remaining_limit);

    if ($keys_to_award <= 0) {
        throw new Exception("No unclaimed invitations available for today");
    }

    // 5. Update ref_bonus_key_records (keep only today's record)
    $key_records = [['date' => $today, 'amount' => $today_keys + $keys_to_award]];

    // 6. Update users table (reflist, key, ref_bonus_key_records)
    $new_key = $current_key + $keys_to_award;
    $update_query = "UPDATE users SET reflist = ?, `key` = ?, ref_bonus_key_records = ? WHERE user_id = ?";
    $stmt = $conn->prepare($update_query);
    $json_reflist = json_encode($updated_reflist);
    $json_key_records = json_encode($key_records);
    $stmt->bind_param("sisi", $json_reflist, $new_key, $json_key_records, $user_id);
    $stmt->execute();

    // Commit transaction
    $conn->commit();

    // Success response
    echo json_encode([
        'status' => 'success',
        'message' => 'Bonus keys claimed successfully',
        'data' => [
            'today_date' => $today,
            'keys_awarded' => $keys_to_award,
            'total_keys' => $new_key,
            'today_invites' => $today_invitations,
            'remaining_keys_today' => $daily_limit - ($today_keys + $keys_to_award),
            'ref_bonus_key_records' => $key_records
        ]
    ]);
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'data' => [
            'today_date' => $today,
            'today_keys' => $today_keys,
            'remaining_keys_today' => $daily_limit - $today_keys,
            'total_keys' => $current_key ?? 0
        ]
    ]);
}

// Close connection
$conn->close();
?>