<?php
header('Content-Type: application/json');

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'ok' => false,
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Get user_id from both GET and POST requests
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
} else {
    $input = json_decode(file_get_contents('php://input'), true);
    $user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;
}

if ($user_id <= 0) {
    echo json_encode([
        'ok' => false,
        'message' => 'Invalid user ID'
    ]);
    exit;
}

// Constants
$DAILY_POINT_LIMIT = 150; // Hardcoded daily point limit
$current_date = date('Y-m-d');

// Start transaction
$conn->begin_transaction();

try {
    // 1. Get user's current ticket points
    $query = "SELECT ticket_point FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        throw new Exception("User not found");
    }
    
    $user_data = $result->fetch_assoc();
    $ticket_points = (int)$user_data['ticket_point'];

    // 2. Get today's earned points from ticket_point_earnings
    $points_query = "SELECT COALESCE(SUM(earned_points), 0) as today_points 
                   FROM ticket_point_earnings 
                   WHERE user_id = ? 
                   AND DATE(earned_at) = ?";
    $stmt = $conn->prepare($points_query);
    $stmt->bind_param("is", $user_id, $current_date);
    $stmt->execute();
    $points_result = $stmt->get_result();
    $today_points = $points_result->fetch_assoc()['today_points'];
    
    $points_left = max(0, $DAILY_POINT_LIMIT - $today_points);

    $conn->commit();

    // Successful response
    echo json_encode([
        'ok' => true,
        'message' => 'Data retrieved successfully',
        'data' => [
            'ticket_point' => $ticket_points,
            'points_earned_today' => $today_points,
            'points_left_today' => $points_left,
            'daily_point_limit' => $DAILY_POINT_LIMIT
        ]
    ]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'ok' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>