<?php
require 'config.php';

header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: https://tgbro.link');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

http_response_code(200);

// Get user_id from both GET and POST
$user_id = $_SERVER['REQUEST_METHOD'] === 'GET' 
    ? ($_GET['user_id'] ?? 0)
    : (json_decode(file_get_contents("php://input"), true)['user_id'] ?? 0);

$user_id = (int)$user_id;

if ($user_id <= 0) {
    echo json_encode(['ok' => false, 'message' => 'Invalid user ID']);
    exit;
}

try {
    // Check if user exists and has an address
    $stmt = $pdo->prepare("SELECT ticket_buy_address FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        throw new Exception("User not found");
    }

    // Return existing address if available
    if (!empty($user['ticket_buy_address'])) {
        echo json_encode([
            'ok' => true,
            'message' => 'Address retrieved',
            'data' => [
                'address' => $user['ticket_buy_address'],
                'is_new' => false
            ]
        ]);
        exit;
    }

    // Create new address via OxaPay API
    $oxapay_url = 'https://api.oxapay.com/v1/payment/static-address';
    $payload = [
        'network' => 'bep20',
        'to_currency' => 'usdt',
        'callback_url' => "https://wenepay.cyou/scratch/api/buy_ticket.php?user_id={$user_id}"
    ];
    
    $headers = [
        'Content-Type: application/json',
        'merchant_api_key: ' . $config['oxapay_api_key']
    ];

    $ch = curl_init($oxapay_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) {
        throw new Exception("OxaPay API connection failed: " . $error);
    }

    $oxapay_response = json_decode($response, true);
    
    if ($oxapay_response['status'] !== 200 || empty($oxapay_response['data']['address'])) {
        throw new Exception("Failed to generate address: " . ($oxapay_response['message'] ?? 'Unknown error'));
    }

    $deposit_address = $oxapay_response['data']['address'];

    // Save to database
    $stmt = $pdo->prepare("UPDATE users SET ticket_buy_address = ? WHERE user_id = ?");
    $stmt->execute([$deposit_address, $user_id]);

    echo json_encode([
        'ok' => true,
        'message' => 'New address generated',
        'data' => [
            'address' => $deposit_address,
            'is_new' => true
        ]
    ]);

} catch (Exception $e) {
    error_log("Address generation failed: " . $e->getMessage(), 3, 'error.log');
    echo json_encode([
        'ok' => false,
        'message' => $e->getMessage()
    ]);
}
?>