<?php
require_once 'config.php';

header('Content-Type: application/json');

// Read JSON input
$input = json_decode(file_get_contents('php://input'), true);

$user_id = $input['user_id'] ?? '';

$response = ['ok' => false, 'message' => '', 'redirect' => '', 'result' => []];

try {
    if (empty($user_id)) {
        $response['message'] = 'User ID is required';
        echo json_encode($response);
        exit;
    }

    // Check if user exists
    $stmt = $pdo->prepare("SELECT balance, last_claim FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        $response['message'] = 'User not found';
        echo json_encode($response);
        exit;
    }

    $today = date('Y-m-d');
    $last_claim = $user['last_claim'] ?? null;

    if ($last_claim === $today) {
        // Already claimed today
        $response['message'] = 'You already claimed today. Try again tomorrow!';
        echo json_encode($response);
        exit;
    }

    // ✅ First tell frontend to redirect to channel
    $response['redirect'] = 'https://t.me/MEAGTASK';

    // Add 50 MEGA to balance & update last_claim
    $new_balance = $user['balance'] + 50;
    $stmt = $pdo->prepare("UPDATE users SET balance = ?, last_claim = ? WHERE user_id = ?");
    $stmt->execute([$new_balance, $today, $user_id]);

    $response['ok'] = true;
    $response['message'] = '50 Mega credited for today';
    $response['result'] = [
        'user_id' => $user_id,
        'new_balance' => $new_balance,
        'last_claim' => $today
    ];

} catch (PDOException $e) {
    $response['message'] = 'Database error: ' . $e->getMessage();
} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

echo json_encode($response);
?>