<?php
header('Content-Type: application/json');
// Database connection
$servername = "localhost";
$username = "sbabewrx_scratch";
$password = "sbabewrx_scratch";
$dbname = "sbabewrx_scratch";
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Connection failed: ' . $conn->connect_error]));
}
// Get input
$input = json_decode(file_get_contents('php://input'), true);
$user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;
$action = isset($input['action']) ? $input['action'] : 'watch';
if ($user_id <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid user ID']);
    exit;
}
// Fetch settings
$settings_query = "SELECT reward_per_ads, daily_limit FROM settings WHERE id = 1";
$settings_result = $conn->query($settings_query);
if (!$settings_result || $settings_result->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'Settings not found']);
    exit;
}
$settings = $settings_result->fetch_assoc();
$reward_per_ads = $settings['reward_per_ads'];
$daily_limit = $settings['daily_limit'];
// Dates
$current_date = date('Y-m-d');
$current_time = date('Y-m-d H:i:s');
// Delete old ad records
$stmt = $conn->prepare("DELETE FROM adswatched WHERE user_id = ? AND watch_date < ?");
$stmt->bind_param("is", $user_id, $current_date);
$stmt->execute();
// Get today's ad watch count
$stmt = $conn->prepare("SELECT COUNT(*) as watch_count FROM adswatched WHERE user_id = ? AND watch_date = ?");
$stmt->bind_param("is", $user_id, $current_date);
$stmt->execute();
$watch_count = $stmt->get_result()->fetch_assoc()['watch_count'];
// Get total ads watched by user (all time)
$stmt = $conn->prepare("SELECT COUNT(*) as total_watched FROM adswatched WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$total_watched = $stmt->get_result()->fetch_assoc()['total_watched'];
// Get milestone status
$stmt = $conn->prepare("SELECT milestone_achieved FROM users WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$milestone_result = $stmt->get_result();
$milestone_achieved = $milestone_result->num_rows > 0 ? $milestone_result->fetch_assoc()['milestone_achieved'] : 0;
// If action = details
if ($action === 'details') {
    echo json_encode([
        'status' => 'success',
        'message' => 'Ad watch details',
        'total_ads_watched' => $total_watched,
        'ads_left_today' => max(0, $daily_limit - $watch_count),
        'reward_per_ads' => $reward_per_ads,
        'milestone_eligible' => ($total_watched >= 1000 && $milestone_achieved == 0),
        'milestone_achieved' => $milestone_achieved
    ]);
    exit;
}
// If action = claim_milestone
if ($action === 'claim_milestone') {
    if ($total_watched < 1000 || $milestone_achieved == 1) {
        echo json_encode(['status' => 'error', 'message' => 'Not eligible for milestone']);
        exit;
    }
    $milestone_reward = 3000;
    $conn->begin_transaction();
    try {
        $stmt = $conn->prepare("UPDATE users SET balance = balance + ?, milestone_achieved = 1 WHERE user_id = ?");
        $stmt->bind_param("di", $milestone_reward, $user_id);
        $stmt->execute();
        $conn->commit();
        $response = [
            'status' => 'success',
            'message' => "Milestone claimed: +{$milestone_reward} mega!",
            'new_balance' => getUserBalance($conn, $user_id)
        ];
    } catch (Exception $e) {
        $conn->rollback();
        $response = ['status' => 'error', 'message' => 'Failed to claim milestone: ' . $e->getMessage()];
        error_log($e->getMessage());
    }
    echo json_encode($response);
    exit;
}
// Daily limit check (for watch action)
if ($watch_count >= $daily_limit) {
    echo json_encode(['status' => 'error', 'message' => 'Daily ad watch limit reached']);
    exit;
}
// === Penalty Logic ===
$stmt = $conn->prepare("DELETE FROM penalties WHERE user_id = ? AND penalty_date != ?");
$stmt->bind_param("is", $user_id, $current_date);
$stmt->execute();
$apply_penalty_now = false;
$threshold_seconds = 12; // Gap threshold
$stmt = $conn->prepare("SELECT last_ad_watch_time FROM users WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$last_ad_result = $stmt->get_result();
$penalty_today = false;
if ($last_ad_result->num_rows > 0) {
    $last_watch_time = $last_ad_result->fetch_assoc()['last_ad_watch_time'];
    if ($last_watch_time !== null) {
        $time_diff = strtotime($current_time) - strtotime($last_watch_time);
        if ($time_diff < $threshold_seconds) {
            $apply_penalty_now = true;
            $stmt = $conn->prepare("SELECT id FROM penalties WHERE user_id = ? AND penalty_date = ?");
            $stmt->bind_param("is", $user_id, $current_date);
            $stmt->execute();
            $penalty_today = $stmt->get_result()->num_rows > 0;
            if (!$penalty_today) {
                $stmt = $conn->prepare("INSERT INTO penalties (user_id, penalty_date) VALUES (?, ?)");
                $stmt->bind_param("is", $user_id, $current_date);
                $stmt->execute();
                $penalty_today = true;
            }
        }
    }
}
// Determine reward and message
$final_reward = $reward_per_ads;
$penalty_message = '';
if ($penalty_today) {
    $final_reward = $reward_per_ads * 0.5;
    $penalty_message = " (50% less for today's penalty)";
}
// === Transaction Start for watch ===
$conn->begin_transaction();
try {
    // Insert ad watch record
    $stmt = $conn->prepare("INSERT INTO adswatched (user_id, watch_date) VALUES (?, ?)");
    $stmt->bind_param("is", $user_id, $current_date);
    $stmt->execute();
    // Update user balance and last ad watch time
    $stmt = $conn->prepare("UPDATE users SET balance = balance + ?, last_ad_watch_time = ? WHERE user_id = ?");
    $stmt->bind_param("dsi", $final_reward, $current_time, $user_id);
    $stmt->execute();
    // Referral bonus using reflist LIKE search
    $user_id_str = (string)$user_id;
    $stmt = $conn->prepare("SELECT id FROM users WHERE reflist LIKE CONCAT('%', ?, '%') LIMIT 1");
    $stmt->bind_param("s", $user_id_str);
    $stmt->execute();
    $referral_result = $stmt->get_result();
    if ($referral_result->num_rows > 0) {
        $referred_by_id = $referral_result->fetch_assoc()['id'];
        if ($referred_by_id > 0 && $referred_by_id != $user_id) {
            // Verify referrer exists (redundant but safe)
            $check_stmt = $conn->prepare("SELECT user_id FROM users WHERE id = ?");
            $check_stmt->bind_param("i", $referred_by_id);
            $check_stmt->execute();
            if ($check_stmt->get_result()->num_rows > 0) {
                $referral_bonus = $final_reward * 0.03; // 3% 
                $stmt = $conn->prepare("UPDATE users SET referral_earnings = referral_earnings + ? WHERE id = ?");
                $stmt->bind_param("di", $referral_bonus, $referred_by_id);
                $stmt->execute();
            }
        }
    }
    // Commit ad watch transaction
    $conn->commit();
    $response = [
        'status' => 'success',
        'message' => "Ad watch recorded." . $penalty_message,
        'new_balance' => getUserBalance($conn, $user_id),
        'earned' => $final_reward,
        'penalty' => $penalty_today ? 'Active' : 'None'
    ];
} catch (Exception $e) {
    $conn->rollback();
    $response = ['status' => 'error', 'message' => 'Failed to record ad watch: ' . $e->getMessage()];
    // Log error for debugging
    error_log($e->getMessage());
}
echo json_encode($response);
$conn->close();
// Helper function
function getUserBalance($conn, $user_id) {
    $stmt = $conn->prepare("SELECT balance FROM users WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->num_rows > 0 ? $result->fetch_assoc()['balance'] : 0;
}
?>