<?php
header('Content-Type: application/json');

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Get user_id from parameters
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$points_to_add = 1; // 1 point per ad watch
$daily_limit = 250; // Max 250 points per day

if ($user_id <= 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid user ID'
    ]);
    exit;
}

// Start transaction
$conn->begin_transaction();

try {
    // 1. Check today's earned points
    $today = date('Y-m-d');
    $check_query = "SELECT SUM(earned_points) AS today_points 
                   FROM ticket_point_earnings 
                   WHERE user_id = ? 
                   AND DATE(earned_at) = ? 
                   AND source = 'ad_watch'";
    $stmt = $conn->prepare($check_query);
    $stmt->bind_param("is", $user_id, $today);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $today_points = $row['today_points'] ?: 0;

    // 2. Verify daily limit
    if ($today_points >= $daily_limit) {
        throw new Exception("Daily ticket point limit (150) reached");
    }

    // 3. Add points to user account
    $update_query = "UPDATE users SET ticket_point = ticket_point + ? WHERE user_id = ?";
    $stmt = $conn->prepare($update_query);
    $stmt->bind_param("ii", $points_to_add, $user_id);
    $stmt->execute();

    // 4. Record the transaction
    $record_query = "INSERT INTO ticket_point_earnings 
                    (user_id, earned_points, source, source_id, earned_at)
                    VALUES (?, ?, 'ad_watch', ?, NOW())";
    $stmt = $conn->prepare($record_query);
    $source_id = 'AD-' . time() . '-' . $user_id; // Unique source ID
    $stmt->bind_param("iis", $user_id, $points_to_add, $source_id);
    $stmt->execute();

    // 5. Get updated balance
    $balance_query = "SELECT ticket_point FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($balance_query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $new_balance = $result->fetch_assoc()['ticket_point'];

    $conn->commit();

    // Success response
    echo json_encode([
        'status' => 'success',
        'message' => 'Ticket point added successfully',
        'data' => [
            'points_added' => $points_to_add,
            'new_balance' => $new_balance,
            'today_earned' => $today_points + $points_to_add,
            'remaining_today' => $daily_limit - ($today_points + $points_to_add)
        ]
    ]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'data' => [
            'today_earned' => $today_points ?? 0,
            'remaining_today' => $daily_limit - ($today_points ?? 0)
        ]
    ]);
}

$conn->close();
?>