<?php  
require 'config.php';  
header('Content-Type: application/json');  
  
define('OXAPAY_API_KEY', 'CQHRYK-VNYMML-QUDMZN-SPNLRZ');  
$fee_mega = 4000; // Fee in MEGA  
$mega_to_ton = 0.00003; // Conversion rate: 1 MEGA = 0.00003 TON  
  
$admin_pin = $_GET['admin_pin'] ?? $_POST['admin_pin'] ?? null;  
  
if ($admin_pin !== $config['admin_pin']) {  
    echo json_encode(['ok' => false, 'message' => 'Unauthorized access. Admin PIN required.']);  
    exit;  
}  
  
// ✅ GET: Return withdrawal history (same structure as before)  
if ($_SERVER['REQUEST_METHOD'] === 'GET') {  
    try {  
        $stmt = $pdo->query("  
            SELECT   
                w.withdraw_id, w.user_id, w.name, w.amount, w.method, w.account, w.status, w.created_at,  
                u.name AS user_name   
            FROM withdraw_history w  
            LEFT JOIN users u ON w.user_id = u.user_id  
            ORDER BY w.created_at DESC  
        ");  
        $withdrawals = $stmt->fetchAll(PDO::FETCH_ASSOC);  
        echo json_encode(['ok' => true, 'withdrawals' => $withdrawals]);  
    } catch (Exception $e) {  
        echo json_encode(['ok' => false, 'message' => 'Database error', 'error' => $e->getMessage()]);  
    }  
    exit;  
}  
  
// ✅ POST: Handle update or delete  
$data = json_decode(file_get_contents("php://input"), true);  
$action = $data['action'] ?? '';  
$payload = $data['payload'] ?? [];  
  
if (!in_array($action, ['update_status', 'delete'])) {  
    echo json_encode(['ok' => false, 'message' => 'Invalid action']);  
    exit;  
}  
  
try {  
    if ($action === 'update_status') {  
        $withdraw_id = $payload['withdraw_id'] ?? '';  
        $new_status = $payload['status'] ?? '';  
  
        if (!in_array($new_status, ['pending', 'approved', 'rejected'])) {  
            echo json_encode(['ok' => false, 'message' => 'Invalid status']);  
            exit;  
        }  
  
        // ✅ Fetch withdrawal record  
        $stmt = $pdo->prepare("SELECT * FROM withdraw_history WHERE withdraw_id = ?");  
        $stmt->execute([$withdraw_id]);  
        $withdraw = $stmt->fetch(PDO::FETCH_ASSOC);  
        if (!$withdraw) {  
            echo json_encode(['ok' => false, 'message' => 'Withdraw record not found']);  
            exit;  
        }  
  
        // ✅ On approval: Process OxaPay & Telegram  
        if ($new_status === 'approved') {  
            $amount_mega = (float)$withdraw['amount']; // Amount in MEGA  
            $method = strtoupper($withdraw['method']);  
            $address = $withdraw['account'];  
            $user_id = $withdraw['user_id'];  
            $net_mega = $amount_mega - $fee_mega;  
  
            if ($net_mega <= 0) {  
                echo json_encode(['ok' => false, 'message' => 'Net amount must be greater than 0']);  
                exit;  
            }  
  
            // Convert to TON  
            $payout_amount = $net_mega * $mega_to_ton; // Net amount in TON  
            $currency = 'DOGE';  
            $network = 'DOGE';  
  
            $description = "Admin Approved Withdrawal #{$withdraw_id} for User {$user_id}";  
  
            // ✅ Send to OxaPay  
            $oxapay_data = [  
                'address'     => $address,  
                'amount'      => $payout_amount,  
                'currency'    => $currency,  
                'network'     => $network,  
                'description' => $description  
            ];  
  
            $context = stream_context_create([  
                'http' => [  
                    'header'  => "Content-Type: application/json\r\npayout_api_key: " . OXAPAY_API_KEY,  
                    'method'  => 'POST',  
                    'content' => json_encode($oxapay_data),  
                    'ignore_errors' => true  
                ]  
            ]);  
  
            $oxapay_response = file_get_contents('https://api.oxapay.com/v1/payout', false, $context);  
            if ($oxapay_response === false) {  
                echo json_encode(['ok' => false, 'message' => 'OxaPay API error']);  
                exit;  
            }  
  
            $oxapay_result = json_decode($oxapay_response, true);  
            if (!empty($oxapay_result['error'])) {  
                echo json_encode(['ok' => false, 'message' => 'OxaPay Error: ' . $oxapay_result['error']['message']]);  
                exit;  
            }  
  
            // ✅ Telegram Message  
            $track_id = $oxapay_result['data']['track_id'] ?? 'N/A';  
  
            $message  = "✅ <b>Withdrawal Approved</b>\n";  
            $message .= "💰 <b>Original Amount:</b> {$amount_mega} MEGA\n";  
            $message .= "💸 <b>Fee:</b> {$fee_mega} MEGA\n";  
            $message .= "📤 <b>Sent:</b> {$payout_amount} DOGE\n";  
            $message .= "💼 <b>Wallet:</b> <code>{$address}</code>\n";  
            $message .= "🆔 <b>Track ID:</b> <code>{$track_id}</code>";  
  
            $tgData = [  
                'chat_id'    => $user_id,  
                'text'       => $message,  
                'parse_mode' => 'HTML'  
            ];  
            $ch = curl_init("https://api.telegram.org/bot{$config['bot_token']}/sendMessage");  
            curl_setopt_array($ch, [  
                CURLOPT_POST => 1,  
                CURLOPT_POSTFIELDS => http_build_query($tgData),  
                CURLOPT_RETURNTRANSFER => true  
            ]);  
            curl_exec($ch);  
            curl_close($ch);  
        }  
  
        // ✅ Update withdrawal status  
        $stmt = $pdo->prepare("UPDATE withdraw_history SET status = ? WHERE withdraw_id = ?");  
        $stmt->execute([$new_status, $withdraw_id]);  
  
        echo json_encode(['ok' => true, 'message' => 'Withdraw status updated']);  
        exit;  
    }  
  
    // ✅ DELETE action  
    if ($action === 'delete') {  
        $withdraw_id = $payload['withdraw_id'] ?? '';  
        $stmt = $pdo->prepare("DELETE FROM withdraw_history WHERE withdraw_id = ?");  
        $stmt->execute([$withdraw_id]);  
        echo json_encode(['ok' => true, 'message' => 'Withdraw record deleted']);  
        exit;  
    }  
} catch (Exception $e) {  
    echo json_encode(['ok' => false, 'message' => 'Database error', 'error' => $e->getMessage()]);  
    exit;  
}  