<?php
header('Content-Type: application/json');

// Database connection
$db_host = "localhost";
$db_name = "sbabewrx_scratch";
$db_user = "sbabewrx_scratch";
$db_pass = "sbabewrx_scratch";

error_reporting(E_ALL);
ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/stats_error.log");

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $data = [];

    // === General stats ===
    $data['total_users'] = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $data['total_keys']  = (int)$pdo->query("SELECT IFNULL(SUM(`key`),0) FROM users")->fetchColumn();
    $data['joined_today'] = (int)$pdo->query("SELECT COUNT(*) FROM users WHERE DATE(created_at)=CURDATE()")->fetchColumn();
    $data['joined_month'] = (int)$pdo->query("SELECT COUNT(*) FROM users WHERE MONTH(created_at)=MONTH(NOW()) AND YEAR(created_at)=YEAR(NOW())")->fetchColumn();

    $check = $pdo->query("SHOW COLUMNS FROM users LIKE 'last_active'");
    $data['active_week'] = $check->rowCount() > 0
        ? (int)$pdo->query("SELECT COUNT(*) FROM users WHERE last_active >= DATE_SUB(NOW(),INTERVAL 7 DAY)")->fetchColumn()
        : (int)$pdo->query("SELECT COUNT(*) FROM users WHERE created_at >= DATE_SUB(NOW(),INTERVAL 7 DAY)")->fetchColumn();

    // === Users by day ===
    $stmt = $pdo->query("
        SELECT DATE(created_at) as day, COUNT(*) as count
        FROM users WHERE created_at >= DATE_SUB(NOW(),INTERVAL 7 DAY)
        GROUP BY DATE(created_at) ORDER BY day ASC
    ");
    $data['users_by_day'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // === Users by month ===
    $stmt = $pdo->query("
        SELECT DATE_FORMAT(created_at,'%Y-%m') as month, COUNT(*) as count
        FROM users GROUP BY month ORDER BY month ASC
    ");
    $data['users_by_month'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // === Claims stats ===
    $tableCheck = $pdo->query("SHOW COLUMNS FROM users LIKE 'last_claim'");
    if ($tableCheck->rowCount() > 0) {
        $data['claims_today'] = (int)$pdo->query("SELECT COUNT(*) FROM users WHERE last_claim=CURDATE()")->fetchColumn();
        $week_start = date('Y-m-d', strtotime('monday this week'));
        $week_end = date('Y-m-d', strtotime('sunday this week'));
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE last_claim BETWEEN ? AND ?");
        $stmt->execute([$week_start, $week_end]);
        $data['claims_week'] = (int)$stmt->fetchColumn();
        $stmt = $pdo->query("
            SELECT DATE(last_claim) as day, COUNT(*) as count
            FROM users WHERE last_claim >= DATE_SUB(NOW(),INTERVAL 7 DAY)
            GROUP BY DATE(last_claim) ORDER BY day ASC
        ");
        $data['claims_by_day'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } else {
        $data['claims_today'] = 0;
        $data['claims_week'] = 0;
        $data['claims_by_day'] = [];
    }

    // === Ads watched stats ===
    $mega_per_ad = 20; // Mega per ad

    // Total ads watched all-time
    $data['ad_watch'] = (int)$pdo->query("SELECT COUNT(*) FROM adswatched")->fetchColumn();

    // Ads watched today (all users)
    $stmt = $pdo->query("SELECT COUNT(*) FROM adswatched WHERE watch_date=CURDATE()");
    $ads_today = (int)$stmt->fetchColumn();
    $data['ads_today'] = $ads_today;

    // Mega earned today
    $data['ads_earnings_today'] = $ads_today * $mega_per_ad;

    // Ads watched grouped by day (last 7 days)
    $stmt = $pdo->query("
      SELECT DATE(watch_date) as day, COUNT(*) as ads_watched
      FROM adswatched
      WHERE watch_date >= DATE_SUB(NOW(), INTERVAL 7 DAY)
      GROUP BY DATE(watch_date)
      ORDER BY day ASC
    ");
    $ads_by_day = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $data['ads_by_day'] = $ads_by_day;

    // Mega earnings by day (last 7 days)
    $ads_earnings_by_day = [];
    foreach ($ads_by_day as $row) {
        $ads_earnings_by_day[] = [
            'day' => $row['day'],
            'total_earnings' => $row['ads_watched'] * $mega_per_ad
        ];
    }
    $data['ads_earnings_by_day'] = $ads_earnings_by_day;

    // ✅ per-user stats if user_id provided
    $user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
    if ($user_id > 0) {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM adswatched WHERE user_id=? AND watch_date=CURDATE()");
        $stmt->execute([$user_id]);
        $data['user_ads_today'] = (int)$stmt->fetchColumn();

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM adswatched WHERE user_id=?");
        $stmt->execute([$user_id]);
        $data['user_ads_total'] = (int)$stmt->fetchColumn();

        $data['user_earn_today'] = $data['user_ads_today'] * $mega_per_ad;
        $data['user_earn_total'] = $data['user_ads_total'] * $mega_per_ad;
    }

    echo json_encode(["status"=>"success","data"=>$data], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    error_log("DB ERROR: ".$e->getMessage());
    echo json_encode(["status"=>"error","message"=>"Database error"]);
}
?>