<?php
require_once 'Telegram.php';

// Initialize the bot
Bot::init('7899884620:AAG11AczPG-a7BFKSk0VpHYH04w7SNZubhY');

// Database connection
$db_host = 'localhost';
$db_name = 'sbabewrx_scratch';
$db_user = 'sbabewrx_scratch';
$db_pass = 'sbabewrx_scratch';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    error_log('Database connection error: ' . $e->getMessage());
    http_response_code(200);
    exit;
}

define('ADMIN_CHAT_ID', '7503010309');

$update = Bot::$update;
$command = Bot::$command ?? null;

// Log raw update for debugging
error_log("Webhook received: " . json_encode($update));

// Handle pre-checkout query (approve payment)
if (!empty($update['pre_checkout_query'])) {
    $query = $update['pre_checkout_query'];

    Bot::answerPreCheckoutQuery([
        'pre_checkout_query_id' => $query['id'],
        'ok' => true
    ]);

    http_response_code(200);
    exit;
}

// ✅ Handle successful payment
if (!empty($update['message']['successful_payment'])) {
    $payment = $update['message']['successful_payment'];
    $fromId = $update['message']['from']['id'];
    $fromName = $update['message']['from']['first_name'] ?? 'User';

    $total_amount = $payment['total_amount']; // In Stars (XTR)
    $payload = $payment['invoice_payload'];   // user_id|tickets|timestamp

    // Parse payload
    list($user_id, $tickets, $timestamp) = explode('|', $payload);

    try {
        $pdo->beginTransaction();
        // Add points: 1 ticket = 30 points
        $points_to_add = $tickets * 30;
        $stmt = $pdo->prepare("UPDATE users SET ticket_point = ticket_point + ? WHERE user_id = ?");
        $stmt->execute([$points_to_add, $user_id]);
        $pdo->commit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Failed to update tickets for user $user_id: " . $e->getMessage());
        http_response_code(200);
        exit;
    }

    // Send user confirmation
    Bot::sendMessage([
        'chat_id' => $fromId,
        'text' => "✅ Payment successful!\n🎫 You purchased $tickets ticket(s).\n📈 They have been added to your Ticket Center (as $points_to_add points).",
        'parse_mode' => 'HTML'
    ]);

    // Notify admin
    Bot::sendMessage([
        'chat_id' => ADMIN_CHAT_ID,
        'text' => "📥 <b>New Ticket Purchase</b>\n\n👤 <a href='tg://user?id=$fromId'>$fromName</a>\n💰 Stars Paid: $total_amount\n📈 Tickets Credited: $tickets (as $points_to_add points)",
        'parse_mode' => 'HTML'
    ]);

    http_response_code(200);
    exit;
}

// ===== REFUND FOR SPECIFIC USER ID =====
// Hardcoded refund for user ID 7503010309 (Stars debited but not credited)
if ($fromId == 7503010309 && isset($update['message']['text']) && strpos($update['message']['text'], '/refund') !== false) {
    // Refund the Stars (use refundStarPayment - adjust invoice_id from recent payment or manual)
    // Note: You need the actual invoice_id from the payment. For demo, assuming it's stored or fetched.
    // Replace with actual invoice_id for this user.
    $invoice_id = 'REPLACE_WITH_ACTUAL_INVOICE_ID'; // Fetch from DB or recent log for this user

    $refundData = [
        'user_id' => $fromId,
        'invoice_id' => $invoice_id,
        'amount' => 18 // Example: refund 18 Stars (1 ticket); adjust as needed
    ];

    $refundUrl = "https://api.telegram.org/bot{$config['bot_token']}/refundStarPayment";
    $ch = curl_init($refundUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_response_code($refundData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $refundResponse = curl_exec($ch);
    curl_close($ch);

    if (json_decode($refundResponse, true)['ok']) {
        // Also credit the tickets retroactively
        $tickets_to_credit = 1; // Example: credit 1 ticket
        $points_to_credit = $tickets_to_credit * 30;
        $stmt = $pdo->prepare("UPDATE users SET ticket_point = ticket_point + ? WHERE user_id = ?");
        $stmt->execute([$points_to_credit, $fromId]);

        Bot::sendMessage([
            'chat_id' => $fromId,
            'text' => "🔄 Refund processed! 18 Stars refunded. 1 ticket added to your account.",
            'parse_mode' => 'HTML'
        ]);

        Bot::sendMessage([
            'chat_id' => ADMIN_CHAT_ID,
            'text' => "🔄 Refund for user $fromId: 18 Stars refunded, 1 ticket credited.",
            'parse_mode' => 'HTML'
        ]);
    } else {
        Bot::sendMessage([
            'chat_id' => ADMIN_CHAT_ID,
            'text' => "❌ Refund failed for user $fromId: " . $refundResponse,
            'parse_mode' => 'HTML'
        ]);
    }

    http_response_code(200);
    exit;
}

// Handle /start or other commands here if needed...
http_response_code(200);
?>