<?php
require_once 'Telegram.php';
require 'config.php';

// =========================
// INIT BOT
// =========================
Bot::init($config['bot_token']);

// =========================
// DATABASE CONNECTION
// =========================
try {
    $pdo = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
        $config['db_user'],
        $config['db_pass']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    error_log("DB ERROR: " . $e->getMessage());
    http_response_code(200);
    exit;
}

define('ADMIN_CHAT_ID', '7503010309');

$update = Bot::$update;
error_log("Webhook12 Incoming: " . json_encode($update));


// =========================
// 1️⃣ APPROVE PRE-CHECKOUT QUERY
// =========================
if (!empty($update['pre_checkout_query'])) {
    Bot::answerPreCheckoutQuery([
        'pre_checkout_query_id' => $update['pre_checkout_query']['id'],
        'ok' => true
    ]);
    http_response_code(200);
    exit;
}


// =========================
// 2️⃣ HANDLE SUCCESSFUL PAYMENT
// =========================
if (!empty($update['message']['successful_payment'])) {

    $payment    = $update['message']['successful_payment'];
    $fromId     = $update['message']['from']['id'];
    $firstName  = $update['message']['from']['first_name'] ?? "User";

    $stars_paid = (int)$payment['total_amount'];  // XTR Stars (already integer)
    $currency   = $payment['currency'];           // must be XTR
    $payload    = $payment['invoice_payload'];    // user_id|stars|timestamp
    $charge_id  = $payment['telegram_payment_charge_id'];

    if ($currency !== "XTR") {
        error_log("Invalid currency received: $currency");
        http_response_code(200);
        exit;
    }

    // Parse payload
    $parts = explode("|", $payload);
    if (count($parts) !== 3) {
        error_log("Invalid payload: $payload");
        http_response_code(200);
        exit;
    }

    $user_id     = (int)$parts[0];
    $stars_value = (int)$parts[1]; // Same as stars_paid
    $timestamp   = (int)$parts[2];

    // Reject if request is too old
    if (time() - $timestamp > 3600) {
        error_log("Payload expired: $payload");
        http_response_code(200);
        exit;
    }

    // =========================
    // OPTIONAL: Prevent duplicate payments
    // =========================
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM star_transactions WHERE charge_id = ?");
    $stmt->execute([$charge_id]);

    if ($stmt->fetchColumn() > 0) {
        error_log("Duplicate charge ignored: $charge_id");
        http_response_code(200);
        exit;
    }

    // Insert transaction record
    $stmt = $pdo->prepare("INSERT INTO star_transactions (user_id, stars, charge_id) VALUES (?, ?, ?)");
    $stmt->execute([$user_id, $stars_paid, $charge_id]);

    // =========================
    // UPDATE USER STAR BALANCE
    // =========================
    try {
        $stmt = $pdo->prepare("UPDATE users SET stars = stars + ? WHERE user_id = ?");
        $stmt->execute([$stars_paid, $user_id]);
        error_log("Added $stars_paid stars to user $user_id");
    } catch (PDOException $e) {
        error_log("Balance update error: " . $e->getMessage());
        http_response_code(200);
        exit;
    }

    // =========================
    // SEND USER CONFIRMATION
    // =========================
    Bot::sendMessage([
        'chat_id' => $fromId,
        'text' => "⭐ <b>Payment successful!</b>\n\nYou purchased <b>$stars_paid Stars</b>.\nThey have been added to your balance.\n\nThank you 💙",
        'parse_mode' => 'HTML'
    ]);

    // =========================
    // NOTIFY ADMIN
    // =========================
    Bot::sendMessage([
        'chat_id' => ADMIN_CHAT_ID,
        'text' =>
            "📌 <b>New Star Purchase</b>\n\n" .
            "👤 <a href='tg://user?id=$fromId'>$firstName</a>\n" .
            "⭐ Stars Paid: <b>$stars_paid</b>\n" .
            "💳 Charge ID: <code>$charge_id</code>",
        'parse_mode' => 'HTML'
    ]);

    http_response_code(200);
    exit;
}


// =========================
// END
// =========================
http_response_code(200);
exit;

?>