<?php
require_once 'Telegram.php';

// Initialize the bot
Bot::init('7899884620:AAG11AczPG-a7BFKSk0VpHYH04w7SNZubhY');

// Database connection
$db_host = 'localhost';
$db_name = 'sbabewrx_scratch';
$db_user = 'sbabewrx_scratch';
$db_pass = 'sbabewrx_scratch';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    error_log('Database connection error: ' . $e->getMessage());
    http_response_code(200);
    exit;
}

define('ADMIN_CHAT_ID', '7503010309');

$update = Bot::$update;
$command = Bot::$command ?? null;

// Log raw update for debugging
error_log("Webhook received: " . json_encode($update));

// Handle pre-checkout query (approve payment)
if (!empty($update['pre_checkout_query'])) {
    $query = $update['pre_checkout_query'];

    Bot::answerPreCheckoutQuery([
        'pre_checkout_query_id' => $query['id'],
        'ok' => true
    ]);

    http_response_code(200);
    exit;
}

// ✅ Handle successful payment
if (!empty($update['message']['successful_payment'])) {
    $payment = $update['message']['successful_payment'];
    $fromId = $update['message']['from']['id'];
    $fromName = $update['message']['from']['first_name'] ?? 'User';

    $stars_amount = (int) $payment['total_amount']; // In Stars (XTR)
    $payload = $payment['invoice_payload'];   // user_id|item_amount|timestamp
    $charge_id = $payment['telegram_payment_charge_id'];
    $currency = $payment['currency'];

    error_log("Processing payment: charge_id=$charge_id, stars=$stars_amount, payload=$payload");

    if ($currency !== 'XTR') {
        error_log("Invalid currency: $currency");
        http_response_code(200);
        exit;
    }

    // Parse payload
    $parts = explode('|', $payload);
    if (count($parts) !== 3) {
        error_log("Invalid payload format: $payload");
        http_response_code(200);
        exit;
    }
    $user_id = (int) $parts[0];
    $item_amount = (int) $parts[1];
    $timestamp = (int) $parts[2];

    // Check freshness (e.g., <1 hour)
    if (time() - $timestamp > 3600) {
        error_log("Payload too old: $payload");
        http_response_code(200);
        exit;
    }

    // Optional: Check for duplicate transaction (if transactions table exists)
    // Comment out if no transactions table
    /*
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM transactions WHERE charge_id = ?");
    $stmt->execute([$charge_id]);
    $count = $stmt->fetchColumn();
    if ($count > 0) {
        error_log("Duplicate charge_id: $charge_id");
        http_response_code(200);
        exit;
    }
    */

    // Determine type (credits or keys)
    $packages = [
        24 => 500,
        48 => 1000,
        120 => 5000,
        300 => 15000
    ];
    $type = null;
    $item_label = '';
    if (isset($packages[$item_amount]) && $packages[$item_amount] === $stars_amount) {
        $type = 'credits';
        $item_label = 'credit(s)';
    } elseif (floor($item_amount * 3.6) === $stars_amount && $item_amount > 0 && $item_amount % 5 === 0) {
        $type = 'keys';
        $item_label = 'key(s)';
    }

    if (!$type) {
        error_log("Invalid type/price match: item $item_amount, stars $stars_amount");
        http_response_code(200);
        exit;
    }

    error_log("Determined type: $type, amount: $item_amount");

    // Optional: Insert transaction (if transactions table exists)
    // Comment out if no transactions table
    /*
    $stmt = $pdo->prepare("INSERT INTO transactions (user_id, type, item_amount, stars_amount, charge_id) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$user_id, $type, $item_amount, $stars_amount, $charge_id]);
    */

    // Update user balance
    $column = ($type === 'credits') ? 'credit' : 'key';
    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE users SET `$column` = `$column` + ? WHERE user_id = ?");
        $stmt->execute([$item_amount, $user_id]);
        $pdo->commit();
        error_log("Updated $column by $item_amount for user $user_id");
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Failed to update $type for user $user_id: " . $e->getMessage());
        http_response_code(200);
        exit;
    }

    // Send user confirmation
    $user_message_sent = Bot::sendMessage([
        'chat_id' => $fromId,
        'text' => "✅ Payment successful!\n💰 You purchased $item_amount $item_label.\n🔑 They have been added to your account.",
        'parse_mode' => 'HTML'
    ]);
    error_log("User message sent: " . ($user_message_sent ? 'success' : 'failed'));

    // Notify admin
    $admin_message_sent = Bot::sendMessage([
        'chat_id' => ADMIN_CHAT_ID,
        'text' => "📥 <b>New Purchase</b>\n\n👤 <a href='tg://user?id=$fromId'>$fromName</a>\n💰 Stars Paid: $stars_amount\n🔑 $item_amount $item_label credited",
        'parse_mode' => 'HTML'
    ]);
    error_log("Admin message sent: " . ($admin_message_sent ? 'success' : 'failed'));

    http_response_code(200);
    exit;
}

// Handle /start or other commands here if needed...
http_response_code(200);
?>