<?php
require_once 'Telegram.php';

// Initialize the bot
Bot::init('7899884620:AAG11AczPG-a7BFKSk0VpHYH04w7SNZubhY');

// Database connection
$db_host = 'localhost';
$db_name = 'sbabewrx_scratch';
$db_user = 'sbabewrx_scratch';
$db_pass = 'sbabewrx_scratch';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    error_log('Database connection error: ' . $e->getMessage());
    http_response_code(200);
    exit;
}

define('ADMIN_CHAT_ID', '7503010309');

$update = Bot::$update;
$command = Bot::$command ?? null;

// Log raw update for debugging
error_log("Webhook received: " . json_encode($update));

// Handle pre-checkout query (approve payment)
if (!empty($update['pre_checkout_query'])) {
    $query = $update['pre_checkout_query'];

    Bot::answerPreCheckoutQuery([
        'pre_checkout_query_id' => $query['id'],
        'ok' => true
    ]);

    http_response_code(200);
    exit;
}

// ✅ Handle successful payment
if (!empty($update['message']['successful_payment'])) {
    $payment = $update['message']['successful_payment'];
    $fromId = $update['message']['from']['id'];
    $fromName = $update['message']['from']['first_name'] ?? 'User';

    $total_amount = $payment['total_amount']; // In Stars (XTR)
    $payload = $payment['invoice_payload'];   // user_id|keys|timestamp

    // Parse payload
    list($user_id, $keys, $timestamp) = explode('|', $payload);

    try {
        $pdo->beginTransaction();

        // Check if user exists
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $exists = $stmt->fetchColumn();

        if (!$exists) {
            // Insert new user if not exists
            $stmt = $pdo->prepare("INSERT INTO users (user_id, name, `key`, total_stars, current_month_stars, last_reset_month) VALUES (?, ?, 0, 0, 0, '0000-00')");
            $stmt->execute([$user_id, $fromName]);
        }

        // Handle monthly reset
        $current_month = date('Y-m');
        $stmt = $pdo->prepare("SELECT last_reset_month FROM users WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $last_reset_month = $stmt->fetchColumn();

        if ($last_reset_month !== $current_month) {
            // Reset current month stars and update last reset
            $stmt = $pdo->prepare("UPDATE users SET current_month_stars = 0, last_reset_month = ? WHERE user_id = ?");
            $stmt->execute([$current_month, $user_id]);
        }

        // Update keys, total_stars, current_month_stars, and name
        $stmt = $pdo->prepare("UPDATE users SET `key` = `key` + ?, total_stars = total_stars + ?, current_month_stars = current_month_stars + ?, name = ? WHERE user_id = ?");
        $stmt->execute([$keys, $total_amount, $total_amount, $fromName, $user_id]);

        $pdo->commit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Failed to update keys for user $user_id: " . $e->getMessage());
        http_response_code(200);
        exit;
    }

    // Send user confirmation
    Bot::sendMessage([
        'chat_id' => $fromId,
        'text' => "✅ Payment successful!\n💰 You purchased $keys key(s).\n🔑 They have been added to your account.",
        'parse_mode' => 'HTML'
    ]);

    // Notify admin
    Bot::sendMessage([
        'chat_id' => ADMIN_CHAT_ID,
        'text' => "📥 <b>New Key Purchase</b>\n\n👤 <a href='tg://user?id=$fromId'>$fromName</a>\n💰 Stars Paid: $total_amount\n🔑 Keys Credited: $keys",
        'parse_mode' => 'HTML'
    ]);

    http_response_code(200);
    exit;
}

// Handle commands
if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $text = trim($message['text'] ?? '');

    if (strtolower($text) === '/leaderboard' || strtolower($text) === '/leaderboard@yourbotname') { // Adjust botname if needed
        try {
            $stmt = $pdo->prepare("SELECT name, current_month_stars FROM users WHERE current_month_stars > 1000 ORDER BY current_month_stars DESC LIMIT 20");
            $stmt->execute();
            $topUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $leaderboardMsg = "<b>🏆 Monthly Leaderboard: Top 20 Star Depositors (Min 1000 Stars)</b>\n\n";

            if (empty($topUsers)) {
                $leaderboardMsg .= "No qualified deposits yet this month. Be the first!\n\n";
            } else {
                foreach ($topUsers as $index => $user) {
                    $rank = $index + 1;
                    $emoji = ($rank == 1) ? '🥇' : (($rank == 2) ? '🥈' : (($rank == 3) ? '🥉' : $rank . '.'));
                    $leaderboardMsg .= "$emoji {$user['name']} - {$user['current_month_stars']} Stars\n";
                }
            }

            $leaderboardMsg .= "\n<b>Prizes:</b>\n🥇 1st Place — 850,000 MEGA (2 TON)\n🥈 2nd Place — 650,000 MEGA (1.5 TON)\n🥉 3rd Place — 450,000 MEGA (1 TON)\n4th – 10th Place — 125,000 MEGA each (0.3 TON)\n11th – 20th Place — 60,000 MEGA each (0.15 TON)";

            Bot::sendMessage([
                'chat_id' => $chat_id,
                'text' => $leaderboardMsg,
                'parse_mode' => 'HTML'
            ]);
        } catch (PDOException $e) {
            error_log("Failed to fetch leaderboard: " . $e->getMessage());
            Bot::sendMessage([
                'chat_id' => $chat_id,
                'text' => "❌ Failed to load leaderboard. Please try again later.",
                'parse_mode' => 'HTML'
            ]);
        }
    }
}

// Handle /start or other commands here if needed...
http_response_code(200);