<?php
include 'config.php';

$oid = '96ff29718b65a700';
$base_url = "https://timewall.io/users/login?oid={$oid}&uid=";

/**
 * ✅ TEST / DIRECT MODE
 * If uid exists → immediately redirect (server-side)
 */
if (isset($_GET['uid']) && is_numeric($_GET['uid'])) {
    header("Location: " . $base_url . $_GET['uid']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Redirecting…</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <script src="https://telegram.org/js/telegram-web-app.js"></script>
</head>
<body>

<p>Opening offerwall…</p>

<script>
(function () {

    // ✅ Only run this IF UID wasn't provided
    if (typeof Telegram === 'undefined' || !Telegram.WebApp) {
        document.body.innerHTML = 'Please open from Telegram.';
        return;
    }

    Telegram.WebApp.ready();

    const user = Telegram.WebApp.initDataUnsafe?.user;

    if (!user || !user.id) {
        alert('Unable to get Telegram user ID.');
        return;
    }

    const redirectUrl = "<?php echo $base_url; ?>" + user.id;

    Telegram.WebApp.openLink(redirectUrl, {
        try_instant_view: false
    });

    setTimeout(() => {
        Telegram.WebApp.close();
    }, 300);

})();
</script>

</body>
</html>