<?php
require 'config.php';
require 'init_data_check.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$advertiser_id = $data['user_id'] ?? 0;

if (!$advertiser_id) {
    echo json_encode(['ok' => false, 'message' => 'Missing advertiser ID.', 'result' => []]);
    exit;
}

try {
    // Fetch ONLY completed/expired ads
    $sql = "
        SELECT 
            t.task_id,
            t.name,
            t.icon,
            t.`limit`,
            t.completed,
            t.created_by,
            COUNT(th.id) AS total_completed,
            MAX(th.completed_at) AS last_completed
        FROM tasks t
        LEFT JOIN task_history th ON t.task_id = th.task_id
        WHERE t.created_by = ?
        GROUP BY t.task_id
        HAVING total_completed >= t.`limit`
        ORDER BY last_completed DESC
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$advertiser_id]);
    $ads = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($ads as &$ad) {
        $ad['status'] = 'expired'; // ✅ all here are completed/expired
        $ad['completed_date'] = $ad['last_completed'] ?? null;
    }

    echo json_encode([
        'ok' => true,
        'message' => 'Task history retrieved successfully.',
        'result' => $ads
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'ok' => false,
        'message' => 'Database error fetching task history: ' . $e->getMessage(),
        'result' => []
    ]);
}