<?php
header('Content-Type: application/json');
include 'db.php';

$input = json_decode(file_get_contents('php://input'), true);
$user_id = $input['user_id'] ?? 0;
$cost = $input['cost'] ?? 0;
$action = $input['action'] ?? 'spin';

registerUser($conn, $user_id);

if ($action === 'get_stars') {
    $stmt = $conn->prepare("SELECT stars FROM users WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stars = $stmt->get_result()->fetch_assoc()['stars'] ?? 0;
    echo json_encode(['status' => 'success', 'stars' => $stars]);
    exit;
}

if ($action !== 'spin' || !in_array($cost, [15,50,200,500])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid action or cost']);
    exit;
}

$stmt = $conn->prepare("SELECT stars, balance FROM users WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stars = $user['stars'];
$balance = $user['balance'];

if ($stars < $cost) {
    echo json_encode(['status' => 'error', 'message' => 'Not enough stars']);
    exit;
}

$stars -= $cost;

// Fetch probs for cost
$probs = [];
$q = $conn->prepare("SELECT prob FROM probabilities WHERE cost = ? ORDER BY reward_id");
$q->bind_param("i", $cost);
$q->execute();
$result = $q->get_result();
while ($row = $result->fetch_assoc()) $probs[] = (float)$row['prob'];

// Pick index
$index = 0;
$r = mt_rand() / mt_getrandmax();
$s = 0;
for ($i = 0; $i < count($probs); $i++) {
    $s += $probs[$i];
    if ($r <= $s) {
        $index = $i;
        break;
    }
}

// Fetch reward
$stmt = $conn->prepare("SELECT * FROM rewards WHERE id = ?");
$id = $index + 1; // Assume 1-based
$stmt->bind_param("i", $id);
$stmt->execute();
$prize = $stmt->get_result()->fetch_assoc();

// Award
if ($prize['type'] === 'star') {
    $stars += $prize['value'];
} elseif ($prize['type'] === 'ton') {
    $balance += $prize['value'];
} elseif ($prize['type'] === 'gift') {
    $unlock_at = date('Y-m-d H:i:s', strtotime('+22 days'));
    $stmt = $conn->prepare("INSERT INTO inventory (user_id, reward_id, title, img, won_at, unlock_at, status) VALUES (?, ?, ?, ?, NOW(), ?, 'locked')");
    $stmt->bind_param("issis", $user_id, $prize['id'], $prize['title'], $prize['img'], $unlock_at);
    $stmt->execute();
}

// Update user
$stmt = $conn->prepare("UPDATE users SET stars = ?, balance = ? WHERE user_id = ?");
$stmt->bind_param("ddi", $stars, $balance, $user_id);
$stmt->execute();

echo json_encode(['status' => 'success', 'prize' => $prize, 'new_stars' => $stars, 'new_balance' => $balance]);
$conn->close();
?>