<?php
declare(strict_types=1);
require 'config.php';
require 'init_data_check.php';
header('Content-Type: application/json');

function respond(bool $ok, string $message, $extra = []) {
    $response = ['ok'=>$ok,'message'=>$message];
    if(!empty($extra)) $response = array_merge($response, $extra);
    echo json_encode($response);
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);
file_put_contents('gift_log.txt', "[".date('Y-m-d H:i:s')."] Webhook received: ".json_encode($data)."\n", FILE_APPEND);

if(empty($data['user_id']) || empty($data['telegram_gift_id'])) {
    respond(false, 'Missing parameters');
}

$user_id = (string)$data['user_id'];
$gift_id = $data['telegram_gift_id'];

// Verify init_data
if(!empty($data['init_data']) && $data['init_data'] !== '786786') {
    $verify = verifyTelegramWebApp($config['bot_token'], $data['init_data']);
    if(!$verify['ok'] || (string)$verify['data']['user']['id'] !== $user_id){
        respond(false, 'Verification failed');
    }
}

// Validate gift against local inventory
try {
    $stmt = $pdo->prepare("SELECT 1 FROM inventory WHERE user_id=? AND reward_id=? LIMIT 1");
    $stmt->execute([$user_id, $gift_id]);
    if (!$stmt->fetchColumn()) {
        respond(false, 'Invalid gift ID or not owned by user.');
    }
} catch(PDOException $e){
    file_put_contents('gift_log.txt', "[".date('Y-m-d H:i:s')."] DB error: ".$e->getMessage()."\n", FILE_APPEND);
    respond(false, 'Database error.');
}

// Remove from inventory (mark as sent)
try {
    $stmt = $pdo->prepare("DELETE FROM inventory WHERE user_id=? AND reward_id=?");
    $stmt->execute([$user_id, $gift_id]);
} catch(PDOException $e){
    file_put_contents('gift_log.txt', "[".date('Y-m-d H:i:s')."] DB error: ".$e->getMessage()."\n", FILE_APPEND);
    respond(false, 'Database error.');
}

// Notify user via Telegram
$sendMsgUrl = "https://api.telegram.org/bot{$config['bot_token']}/sendMessage";
$post = [
    'chat_id' => $user_id,
    'text' => "🎁 Gift '{$gift_id}' has been sent to your profile!"
];
$ch = curl_init($sendMsgUrl);
curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($post),
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_RETURNTRANSFER => true
]);
$response = curl_exec($ch);
curl_close($ch);

respond(true, 'Gift sent successfully ✅');