<?php
declare(strict_types=1);

require 'config.php';
header('Content-Type: application/json');

try {
    $stmt = $pdo->query("SELECT * FROM rewards");
    $rewards = $stmt->fetchAll();

    $stmt = $pdo->query("SELECT * FROM probabilities");
    $probabilities = $stmt->fetchAll();

    echo json_encode([
        'ok' => true,
        'rewards' => $rewards,
        'probabilities' => $probabilities
    ]);
} catch (PDOException $e) {
    echo json_encode(['ok' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}