<?php
header('Content-Type: application/json');

// Database connection
$servername = "localhost";
$username = "sbabewrx_scratch";
$password = "sbabewrx_scratch";
$dbname = "sbabewrx_scratch";
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Connection failed: ' . $conn->connect_error]));
}

// Get input
$input = json_decode(file_get_contents('php://input'), true);
$user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;
$action = isset($input['action']) ? $input['action'] : '';

if ($user_id <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid user ID']);
    exit;
}

// Quest milestones (ads watched => reward mega)
$milestones = [
    10 => 10,
    100 => 100,
    500 => 200,
    1000 => 500
];

// Get total ads watched all time
$stmt = $conn->prepare("SELECT COUNT(*) as total_watched FROM adswatched WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$total_watched = $stmt->get_result()->fetch_assoc()['total_watched'];

// Get weekly ads watched (for progress only)
$current_year = date('Y');
$current_week = date('W');

$stmt = $conn->prepare("SELECT COUNT(*) as weekly_watched 
    FROM adswatched 
    WHERE user_id = ? AND YEAR(watch_date) = ? AND WEEK(watch_date, 3) = ?");
$stmt->bind_param("iii", $user_id, $current_year, $current_week);
$stmt->execute();
$weekly_watched = $stmt->get_result()->fetch_assoc()['weekly_watched'];

// ============ GET QUESTS ============
if ($action === 'get_quests') {
    $quests = [];

    foreach ($milestones as $ms_ads => $ms_reward) {
        $claimed = hasClaimedMilestone($conn, $user_id, $ms_ads);
        $eligible = ($weekly_watched >= $ms_ads && !$claimed);
        $progress = min(100, ($weekly_watched / $ms_ads) * 100);

        $quests[] = [
            'milestone_ads' => $ms_ads,
            'reward' => $ms_reward,
            'progress' => $progress,
            'claimed' => $claimed,
            'eligible' => $eligible
        ];
    }

    echo json_encode([
        'status' => 'success',
        'total_ads_watched' => $total_watched,
        'weekly_ads_watched' => $weekly_watched,
        'quests' => $quests
    ]);
    exit;
}

// ============ CLAIM QUEST ============
elseif ($action === 'claim_quest') {

    $milestone = intval($input['milestone'] ?? 0);

    if (!array_key_exists($milestone, $milestones)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid milestone']);
        exit;
    }

    $reward = $milestones[$milestone];

    // ❗ BLOCK IF ALREADY CLAIMED (PHP CHECK)
    if (hasClaimedMilestone($conn, $user_id, $milestone)) {
        echo json_encode(['status' => 'error', 'message' => 'You have already claimed this quest']);
        exit;
    }

    // Not enough ads watched
    if ($weekly_watched < $milestone) {
        echo json_encode(['status' => 'error', 'message' => 'Not eligible yet']);
        exit;
    }

    // Begin transaction
    $conn->begin_transaction();

    try {
        $current_time = date('Y-m-d H:i:s');

        // Insert milestone claim
        $stmt = $conn->prepare("INSERT INTO user_milestones (user_id, milestone, reward, claimed_date) 
                                VALUES (?, ?, ?, ?)");
        $stmt->bind_param("iids", $user_id, $milestone, $reward, $current_time);
        $stmt->execute();

        // ❗ MySQL duplicate error handling (unique claim protection)
        if ($stmt->errno == 1062) {
            $conn->rollback();
            echo json_encode(['status' => 'error', 'message' => 'You already claimed this quest']);
            exit;
        }

        // Update user balance
        $stmt = $conn->prepare("UPDATE users SET balance = balance + ? WHERE user_id = ?");
        $stmt->bind_param("di", $reward, $user_id);
        $stmt->execute();

        // Commit
        $conn->commit();

        echo json_encode([
            'status' => 'success',
            'message' => 'Quest claimed successfully!',
            'new_balance' => getUserBalance($conn, $user_id),
            'quest_earned' => $reward
        ]);
    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(['status' => 'error', 'message' => 'Failed to claim quest']);
    }

    exit;
}

// Invalid action
else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
    exit;
}

$conn->close();

// ====================
// Helper Functions
// ====================

// Strict claimed check (lifetime)
function hasClaimedMilestone($conn, $user_id, $milestone) {
    $stmt = $conn->prepare("SELECT 1 FROM user_milestones 
                            WHERE user_id = ? AND milestone = ?");
    $stmt->bind_param("ii", $user_id, $milestone);
    $stmt->execute();
    return $stmt->get_result()->num_rows > 0;
}

// Get balance
function getUserBalance($conn, $user_id) {
    $stmt = $conn->prepare("SELECT balance FROM users WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $r = $stmt->get_result()->fetch_assoc();
    return $r['balance'] ?? 0;
}
?>