<?php
header('Content-Type: application/json');
include 'db.php';

$input = json_decode(file_get_contents('php://input'), true);
$user_id = $input['user_id'] ?? 0;

registerUser($conn, $user_id);

$rewards = $conn->query("SELECT * FROM rewards")->fetch_all(MYSQLI_ASSOC);
$probs = [];
$costs = [15,50,200,500];
foreach ($costs as $cost) {
    $probs[$cost] = [];
    $q = $conn->query("SELECT prob FROM probabilities WHERE cost = $cost ORDER BY reward_id");
    while ($row = $q->fetch_assoc()) $probs[$cost][] = (float)$row['prob'];
}

$rtp = 0.98; // From settings

$stmt = $conn->prepare("SELECT stars, balance AS mega FROM users WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

echo json_encode(['ok' => true, 'rewards' => $rewards, 'probabilities' => $probs, 'rtp' => $rtp, 'user' => $user]);
$conn->close();
?>