<?php
declare(strict_types=1);

require 'config.php';
require 'init_data_check.php';
header('Content-Type: application/json');

// Helper: return JSON
function respond(bool $ok, string $message, array $extra = []): void {
    $res = ['ok' => $ok, 'message' => $message];
    if (!empty($extra)) $res = array_merge($res, $extra);
    echo json_encode($res);
    exit;
}

// Input
$input = json_decode(file_get_contents("php://input"), true);
if (!$input || !isset($input['user_id']) || !isset($input['init_data'])) {
    respond(false, "Missing required fields.");
}

$user_id = trim($input['user_id']);
$init_data = $input['init_data'];

// Validate Telegram initData
if ($init_data !== '786786') {
    $verify = verifyTelegramWebApp($config['bot_token'], $init_data);
    if (!$verify['ok']) respond(false, "Init data verification failed.");
    if ((string)$verify['data']['user']['id'] !== $user_id) {
        respond(false, "User ID mismatch.");
    }
}

try {
    // Fetch user's stars and balance
    $stmt = $pdo->prepare("SELECT stars, balance FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) respond(false, "User not found.");

    // Fetch user's inventory (gifts/NFTs only for this user)
    $stmt = $pdo->prepare("
        SELECT reward_id, title, img, unlock_at
        FROM inventory
        WHERE user_id = ?
        ORDER BY unlock_at DESC
    ");
    $stmt->execute([$user_id]);
    $inventory = $stmt->fetchAll(PDO::FETCH_ASSOC);

    respond(true, "User inventory fetched successfully.", [
        'user' => $user,
        'inventory' => $inventory
    ]);

} catch (Exception $e) {
    respond(false, "Error fetching inventory: " . $e->getMessage());
}
?>