<?php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 0);

$body = file_get_contents('php://input');
$input = json_decode($body, true);

if (!$input || empty($input['amount']) || empty($input['pay_currency']) || empty($input['network'])) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'message' => 'Invalid request parameters.']);
    exit;
}

$merchant_api_key = "JSCWPO-YHHJEV-LNCH6I-USRJEC"; // Your key

$invoiceData = [
    "amount" => $input['amount'],
    "currency" => "USD",
    "pay_currency" => $input['pay_currency'],
    "network" => $input['network'],
    "lifetime" => 60,
    "fee_paid_by_payer" => 1,
    "under_paid_coverage" => 20,
    "to_currency" => "USDT",
    "auto_withdrawal" => false,
    "order_id" => "ORD-" . time(),
    "description" => "Deposit"
];

try {
    $url = "https://api.oxapay.com/v1/payment/white-label";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($invoiceData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "merchant_api_key: {$merchant_api_key}",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);

    $resp = curl_exec($ch);
    if ($resp === false) {
        $err = curl_error($ch);
        curl_close($ch);
        http_response_code(500);
        echo json_encode(['ok' => false, 'message' => "cURL error: " . $err]);
        exit;
    }
    curl_close($ch);

    $json = json_decode($resp, true);
    if (!is_array($json) || $json['status'] !== 200) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'message' => 'Failed to generate invoice.']);
        exit;
    }

    echo json_encode(['ok' => true, 'data' => $json['data']]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'message' => $e->getMessage()]);
    exit;
}
?>