<?php
header('Content-Type: application/json');

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Get user_id from parameters
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$daily_limit = 50; // Max 20 ad watches per day

if ($user_id <= 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid user ID'
    ]);
    exit;
}

// Start transaction
$conn->begin_transaction();
try {
    // Get current date
    $today = date('Y-m-d');

    // 1. Fetch current ads_watch_history and key
    $query = "SELECT ads_watch_history, `key` FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    if (!$row) {
        throw new Exception("User not found");
    }

    // Initialize ads watch history
    $ads_history = $row['ads_watch_history'] ? json_decode($row['ads_watch_history'], true) : [];
    if (!is_array($ads_history)) {
        $ads_history = [];
    }
    $current_key = $row['key'] ?? 0;

    // 2. Remove old dates, keep only today's data
    $ads_history = [$today => isset($ads_history[$today]) ? $ads_history[$today] : 0];

    // 3. Check daily limit
    if ($ads_history[$today] >= $daily_limit) {
        throw new Exception("Daily ad watch limit ($daily_limit) reached");
    }

    // 4. Increment today's ad watch count and key
    $ads_history[$today]++;
    $new_key = $current_key + 1;

    // 5. Update ads_watch_history and key in users table
    $update_query = "UPDATE users SET ads_watch_history = ?, `key` = ? WHERE user_id = ?";
    $stmt = $conn->prepare($update_query);
    $json_history = json_encode($ads_history);
    $stmt->bind_param("sii", $json_history, $new_key, $user_id);
    $stmt->execute();

    // Commit transaction
    $conn->commit();

    // Success response
    echo json_encode([
        'status' => 'success',
        'message' => 'Ad watch recorded and key incremented successfully',
        'data' => [
            'today_date' => $today,
            'today_count' => $ads_history[$today],
            'remaining_today' => $daily_limit - $ads_history[$today],
            'key' => $new_key
        ]
    ]);
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'data' => [
            'today_count' => isset($ads_history[$today]) ? $ads_history[$today] : 0,
            'remaining_today' => $daily_limit - (isset($ads_history[$today]) ? $ads_history[$today] : 0),
            'key' => $current_key ?? 0
        ]
    ]);
}

// Close connection
$conn->close();
?>