
<?php
header('Content-Type: application/json');

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Get user_id from parameters
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$daily_limit = 50; // Max 50 ad watches/keys per day

if ($user_id <= 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid user ID'
    ]);
    exit;
}

try {
    // Get current date
    $today = date('Y-m-d');

    // Fetch ads_watch_history, reflist, ref_bonus_key_records, and key
    $query = "SELECT ads_watch_history, reflist, ref_bonus_key_records, `key` FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    if (!$row) {
        throw new Exception("User not found");
    }

    // Parse JSON data
    $ads_history = $row['ads_watch_history'] ? json_decode($row['ads_watch_history'], true) : [];
    $reflist = $row['reflist'] ? json_decode($row['reflist'], true) : [];
    $key_records = $row['ref_bonus_key_records'] ? json_decode($row['ref_bonus_key_records'], true) : [];
    $total_keys = $row['key'] ?? 0;

    if (!is_array($ads_history) || !is_array($reflist) || !is_array($key_records)) {
        $ads_history = [];
        $reflist = [];
        $key_records = [];
    }

    // Calculate ad watches left
    $today_ad_watches = isset($ads_history[$today]) ? $ads_history[$today] : 0;
    $ad_watches_left = $daily_limit - $today_ad_watches;

    // Calculate unclaimed invitations for today
    $today_invitations = 0;
    foreach ($reflist as $entry) {
        $entry_date = substr($entry['date'], 0, 10);
        $is_unclaimed = !isset($entry['key_claimed']) || $entry['key_claimed'] !== true;
        if ($entry_date === $today && $is_unclaimed) {
            $today_invitations++;
        }
    }

    // Calculate keys claimed today
    $today_keys = 0;
    foreach ($key_records as $record) {
        if ($record['date'] === $today) {
            $today_keys = $record['amount'];
            break;
        }
    }

    // Success response
    echo json_encode([
        'status' => 'success',
        'message' => 'User stats retrieved successfully',
        'data' => [
            'today_date' => $today,
            'ad_watches_left' => $ad_watches_left,
            'invitations_ready_to_claim' => min($today_invitations, $daily_limit - $today_keys),
            'keys_claimed_today' => $today_keys,
            'total_keys' => $total_keys
        ]
    ]);
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'data' => [
            'today_date' => $today,
            'ad_watches_left' => 0,
            'invitations_ready_to_claim' => 0,
            'keys_claimed_today' => 0,
            'total_keys' => 0
        ]
    ]);
}

// Close connection
$conn->close();
?>
