<?php
header('Content-Type: application/json');

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Query to get the most recent active draw
$query = "SELECT 
            id,
            prize,
            is_active,
            winners,
            JSON_LENGTH(participants) AS participant_count,
            created_at,
            drawn_at
          FROM draw
          WHERE is_active = TRUE
          ORDER BY created_at DESC
          LIMIT 1";

$result = $conn->query($query);

if (!$result) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error',
        'error' => $conn->error
    ]);
    exit;
}

if ($result->num_rows === 0) {
    echo json_encode([
        'status' => 'success',
        'message' => 'No active draws currently',
        'data' => null
    ]);
    exit;
}

$draw_data = $result->fetch_assoc();

// Format the response
$response = [
    'status' => 'success',
    'message' => 'Draw rules retrieved successfully',
    'data' => [
        'draw_id' => (int)$draw_data['id'],
        'prize_amount' => (float)$draw_data['prize'],
        'is_active' => (bool)$draw_data['is_active'],
        'max_winners' => (int)$draw_data['winners'],
        'current_participants' => (int)$draw_data['participant_count'],
        'created_at' => $draw_data['created_at'],
        'draw_time' => $draw_data['drawn_at'] ?: 'Not drawn yet'
    ]
];

echo json_encode($response);

$conn->close();
?>