<?php
require 'config.php';

// ===== LOG SETUP =====
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/buy_credits.log');

// Read input from POST body
$input = file_get_contents("php://input");
$data = json_decode($input, true) ?? [];
$action = $data['action'] ?? null;
$user_id = $data['user_id'] ?? null;
$credits = (int) ($data['credits'] ?? 0);
$stars = (int) ($data['stars'] ?? 0); // Unused, but logged for reference
$init_data = $data['init_data'] ?? null; // For potential future validation

error_log("=== Buy Credits Request ===");
error_log("Input: " . $input);
error_log("Action: " . $action . " | User: " . $user_id . " | Credits: " . $credits . " | Stars: " . $stars . " | Init Data: " . substr($init_data ?? '', 0, 50) . "...");

// ✅ Allowed packages (credits => XTR price)
$packages = [
    24  => 500,    // 24 credits → 500 XTR
    48  => 1000,   // 48 credits → 1000 XTR
    120 => 5000,   // 120 credits → 5000 XTR
    300 => 15000   // 300 credits → 15000 XTR
];

// ✅ Validation
if ($action !== 'create_invoice' || !$user_id || !isset($packages[$credits])) {
    $msg = "Invalid request (action: $action, user_id: $user_id, credits: $credits)";
    error_log("ERROR: " . $msg);
    echo json_encode(['ok' => false, 'message' => $msg]);
    exit;
}

// TODO: Add init_data validation here if needed (e.g., verify Telegram signature)

$star_price = $packages[$credits];
error_log("Price => $star_price XTR");

// ✅ Payload passed to callback later
$payload = $user_id . "|" . $credits . "|" . time();

$invoice = [
    'title' => "Buy $credits Credits",
    'description' => "Purchase $credits credits in MegaTask",
    'payload' => $payload,
    'currency' => "XTR",
    'prices' => [
        ["label" => "$credits Credits", "amount" => $star_price]
    ]
];

// ✅ Request to Telegram
$url = "https://api.telegram.org/bot{$config['bot_token']}/createInvoiceLink";
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($invoice));
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

error_log("Telegram Response (HTTP $http_code): " . $response);

$result = json_decode($response, true);

if (!empty($result['ok']) && isset($result['result'])) {
    echo json_encode([
        'ok' => true,
        'invoice_link' => $result['result']
    ]);
} else {
    $desc = $result['description'] ?? 'Unknown error';
    error_log("Invoice Error: " . $desc);
    echo json_encode(['ok' => false, 'message' => $desc]);
}

// ===== AUTO-SET WEBHOOK =====
$webhook_url = "https://wenepay.cyou/scratch/api/webhook1.php";
$setWebhookUrl = "https://api.telegram.org/bot{$config['bot_token']}/setWebhook?url=" . urlencode($webhook_url);
$webhook_response = file_get_contents($setWebhookUrl);
error_log("Webhook Set Response: " . $webhook_response);
?>