<?php
// Enable CORS (adjust origin in production)
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Replace * with specific domain (e.g., 'https://your-frontend-domain.com') in production
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

require 'config.php'; // Contains $config['bot_token']

// Database configuration
$db_config = [
    'host' => 'localhost',
    'username' => 'sbabewrx_scratch',
    'password' => 'sbabewrx_scratch',
    'database' => 'sbabewrx_scratch'
];

// Create connection
$conn = new mysqli($db_config['host'], $db_config['username'], $db_config['password'], $db_config['database']);

// Check connection
if ($conn->connect_error) {
    http_response_code(500);
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $conn->connect_error
    ]));
}

// Get input data
$input = json_decode(file_get_contents('php://input'), true);
if ($_SERVER['REQUEST_METHOD'] === 'POST' && json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    die(json_encode([
        'status' => 'error',
        'message' => 'Invalid JSON input'
    ]));
}

$action = isset($input['action']) ? $input['action'] : (isset($_GET['action']) ? $_GET['action'] : 'fetch');
$draw_id = 1; // Fixed draw ID

try {
    // Get current draw data
    $draw_query = "SELECT prize, participants FROM draw WHERE id = ?";
    $stmt = $conn->prepare($draw_query);
    $stmt->bind_param("i", $draw_id);
    $stmt->execute();
    $draw_result = $stmt->get_result();
    
    if ($draw_result->num_rows === 0) {
        throw new Exception("Draw not found");
    }
    
    $draw = $draw_result->fetch_assoc();
    $participants = json_decode($draw['participants'], true);
    if (!is_array($participants)) {
        throw new Exception("Invalid participants data in database");
    }

    switch ($action) {
        case 'fetch':
            $response = [
                'status' => 'success',
                'data' => [
                    'total_participants' => count($participants),
                    'prize' => $draw['prize'],
                    'next_draw_day' => 'Sunday',
                    'prize_per_winner' => $draw['prize']
                ]
            ];
            break;

        case 'update':
            $new_prize = isset($input['new_prize']) ? (float)$input['new_prize'] : null;
            
            if ($new_prize === null || $new_prize <= 0) {
                throw new Exception("Invalid prize amount");
            }

            $update_query = "UPDATE draw SET prize = ? WHERE id = ?";
            $stmt = $conn->prepare($update_query);
            $stmt->bind_param("di", $new_prize, $draw_id);
            $stmt->execute();
            
            $response = [
                'status' => 'success',
                'message' => 'Prize updated successfully',
                'data' => [
                    'new_prize' => $new_prize,
                    'prize_per_winner' => $new_prize
                ]
            ];
            break;

        case 'select_winner':
            if (count($participants) < 3) {
                throw new Exception("Not enough participants (minimum 3 required)");
            }

            // Select 3 random winners
            $winners = [];
            $winner_keys = array_rand($participants, 3);
            foreach ((array)$winner_keys as $key) {
                $winners[] = $participants[$key];
            }

            // Non-winners
            $non_winners = array_diff($participants, $winners);

            // Full prize to each winner
            $prize_per_winner = $draw['prize'];
            $total_distributed = $draw['prize'] * 3;
            
            foreach ($winners as $winner_id) {
                $update_balance = "UPDATE users SET balance = balance + ? WHERE user_id = ?";
                $stmt = $conn->prepare($update_balance);
                $stmt->bind_param("di", $prize_per_winner, $winner_id);
                $stmt->execute();

                // Notify winners privately
                $telegram_message = urlencode("🎉 Congratulations! You won {$prize_per_winner} MEGA in our weekly draw!");
                $telegram_url = "https://api.telegram.org/bot{$config['bot_token']}/sendMessage?chat_id={$winner_id}&text={$telegram_message}";
                $ch = curl_init($telegram_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $result = curl_exec($ch);
                if ($result === false) {
                    error_log("cURL Error: " . curl_error($ch) . " for URL: $telegram_url");
                    throw new Exception("Failed to send Telegram message to winner $winner_id");
                }
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                if ($http_code != 200) {
                    error_log("Telegram API Error: $result");
                    throw new Exception("Telegram API error for winner $winner_id: $result");
                }
                curl_close($ch);
            }

            // Give 700 to non-winners
            foreach ($non_winners as $non_winner_id) {
                $update_balance = "UPDATE users SET balance = balance + 700 WHERE user_id = ?";
                $stmt = $conn->prepare($update_balance);
                $stmt->bind_param("i", $non_winner_id);
                $stmt->execute();
            }

            // Clear participants for next draw
            $clear_participants = "UPDATE draw SET participants = '[]' WHERE id = ?";
            $stmt = $conn->prepare($clear_participants);
            $stmt->bind_param("i", $draw_id);
            $stmt->execute();

            // Prepare channel message
            $channel_chat_id = "@MEAGTASK";
            $channel_bot_token = $config['channel_bot_token'] ?? "8106838212:AAH3TXNeZBSMIJOLYmcjHmSyl-V3My0wCGM";

            $message = "*_Congratulations to the winners of weekly draw 🎉_*\n\n";
            $message .= "*WINNERS*\n";
            foreach ($winners as $index => $winner_id) {
                $message .= ($index + 1) . ". *{$winner_id}* - 50k SHIB\n";
            }
            $message .= "\n_Additional 700 SHIB has been transferred to all participants who didn't win this time._";

            // Send to channel
            $channel_url = "https://api.telegram.org/bot{$channel_bot_token}/sendMessage";
            $post_fields = [
                'chat_id' => $channel_chat_id,
                'text' => $message,
                'parse_mode' => 'Markdown'
            ];

            $ch = curl_init($channel_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
            $result = curl_exec($ch);
            if ($result === false) {
                error_log("cURL Error: " . curl_error($ch) . " for URL: $channel_url");
                throw new Exception("Failed to send Telegram channel message");
            }
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($http_code != 200) {
                error_log("Telegram API Error: $result");
                throw new Exception("Telegram API error for channel: $result");
            }
            curl_close($ch);

            $response = [
                'status' => 'success',
                'message' => 'Winners selected, prizes distributed, and channel updated',
                'data' => [
                    'winners' => $winners,
                    'non_winners_reward' => 700,
                    'prize_per_winner' => $prize_per_winner,
                    'total_prize_distributed' => $total_distributed,
                    'participants_cleared' => true
                ]
            ];
            break;

        default:
            throw new Exception("Invalid action");
    }

} catch (Exception $e) {
    http_response_code(500);
    $response = [
        'status' => 'error',
        'message' => $e->getMessage()
    ];
}

echo json_encode($response);
$conn->close();
?>