<?php
// --------------------
// ERROR LOGGING
// --------------------
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error_log.txt');

// --------------------
// API CONFIG
// --------------------
$api_url = 'https://wenepay.cyou/scratch/admin/gift.php';
$admin_pin = 'kinikaprosper0'; // Replace with your actual admin PIN from config.php

// --------------------
// TELEGRAM UPDATE
// --------------------
$update = json_decode(file_get_contents("php://input"), true);
file_put_contents("error_log.txt", date("Y-m-d H:i:s") . " UPDATE: " . print_r($update, true) . "\n", FILE_APPEND);

if (!isset($update['message'])) {
    exit;
}

$chat_id = $update["message"]["chat"]["id"] ?? null;
$user_id = $update["message"]["from"]["id"] ?? null;
$username = $update["message"]["from"]["username"] ?? "Unknown";
$text = trim($update["message"]["text"] ?? "");

if (!$chat_id || !$user_id) {
    exit;
}

// --------------------
// SUPER ADMIN & FILES
// --------------------
$super_admin = 7503010309;
$adminFile = __DIR__ . "/admins.json";
$cooldownFile = __DIR__ . "/cooldowns.json";

// Initialize admins.json if not exists
if (!file_exists($adminFile)) file_put_contents($adminFile, json_encode([$super_admin]));
$admins = json_decode(file_get_contents($adminFile), true);

// Ensure super admin always exists
if (!in_array($super_admin, $admins)) {
    $admins[] = $super_admin;
    file_put_contents($adminFile, json_encode($admins));
}

// --------------------
// TELEGRAM HELPER
// --------------------
$botToken = "8256850220:AAGHkODRKDZr6ejm0lCToPb8UY7K08z3w6w";
function sendMsg($chat_id, $msg) {
    global $botToken;
    file_get_contents("https://api.telegram.org/bot$botToken/sendMessage?" . http_build_query([
        "chat_id" => $chat_id,
        "text" => $msg,
        "parse_mode" => "HTML"
    ]));
}

// --------------------
// API CALL HELPER
// --------------------
function apiCall($data) {
    global $api_url;
    $options = [
        'http' => [
            'header'  => "Content-type: application/json\r\n",
            'method'  => 'POST',
            'content' => json_encode($data)
        ]
    ];
    $context = stream_context_create($options);
    $result = file_get_contents($api_url, false, $context);
    return json_decode($result, true);
}

// --------------------
// HELPER FUNCTIONS
// --------------------
function saveAdmins($admins) {
    file_put_contents(__DIR__ . "/admins.json", json_encode($admins));
}

function redeemCode($code, $user_id, $chat_id, $username) {
    global $admin_pin;
    $data = [
        'action' => 'redeem',
        'gift_code' => strtoupper($code),
        'user_id' => $user_id
    ];
    $res = apiCall($data);
    if ($res['ok']) {
        sendMsg($chat_id, "✅ <b>Success!</b>\nYou have claimed <b>" . $res['result']['prize'] . " MEGA</b>!\n\nThank you for using the code.");
    } else {
        sendMsg($chat_id, "❌ <b>" . $res['message'] . "</b>\nPlease check the code and try again.");
    }
}

// --------------------
// PARSE INPUT
// --------------------
$command = '';
$arguments = '';
$is_command = strpos($text, '/') === 0;

if ($is_command) {
    $parts = preg_split('/\s+/', $text, 2);
    $command_part = $parts[0];
    $arguments = isset($parts[1]) ? trim($parts[1]) : '';
    $command = preg_replace('/@.*/', '', $command_part);
}

// --------------------
// HANDLE COMMANDS & REDEEM
// --------------------

if ($command === "/start") {
    if (in_array($user_id, $admins)) {
        sendMsg($chat_id, "🎉 <b>Welcome, Admin!</b>\n\nYou now have full access to the Mega Bot control panel.\n\n💡 Available commands:\n• /newcode — Generate a new gift code\n• /history — View your code history\n• /stats — View all codes and claims (super admin only)\n\n🚀 Manage codes efficiently and track user claims with ease!");
    } else {
        sendMsg($chat_id, "🎉 <b>Welcome to Mega Bot!</b>\n\nSend a gift code to claim your reward.");
    }
    exit;
}

if ($is_command) {
    if (!in_array($user_id, $admins)) {
        sendMsg($chat_id, "❌ <b>Access Denied!</b>\nYou are not authorized to use commands.");
        exit;
    }

    // /addadmin (super admin only)
    if ($command === "/addadmin") {
        if ($user_id != $super_admin) {
            sendMsg($chat_id, "❌ <b>Access Denied!</b>\nOnly the super admin can add new admins.");
            exit;
        }

        $parts = explode(" ", $arguments);
        $newAdmin = $parts[0] ?? "";

        if ($newAdmin === "") {
            sendMsg($chat_id, "⚠️ <b>Invalid Command Format!</b>\nUsage:\n/addadmin &lt;user_id&gt;");
            exit;
        }

        if (!in_array($newAdmin, $admins)) {
            $admins[] = (int)$newAdmin;
            saveAdmins($admins);
        }

        sendMsg($chat_id, "✅ <b>Success!</b>\n\nNew admin added: <b>$newAdmin</b>\nThey now have access to generate and manage codes.");
        exit;
    }

    // /newcode (super admin unlimited, normal admin 2h cooldown)
    if ($command === "/newcode") {
        global $admin_pin;
        $reward = rand(50, 300);
        $max_users = 100;

        if ($user_id != $super_admin) {
            $cooldown = file_exists($cooldownFile) ? json_decode(file_get_contents($cooldownFile), true) : [];
            $lastTime = $cooldown[$user_id] ?? 0;
            if (time() - $lastTime < 7200) {
                $left = 7200 - (time() - $lastTime);
                sendMsg($chat_id, "⏳ <b>Cooldown Active!</b>\nPlease wait <b>" . floor($left / 60) . " minutes</b> before generating another code.");
                exit;
            }
            $cooldown[$user_id] = time();
            file_put_contents($cooldownFile, json_encode($cooldown));
        }

        $code = strtoupper(substr(md5(time() . $user_id), 0, 8));

        $data = [
            'action' => 'create',
            'admin_password' => $admin_pin,
            'gift_code' => $code,
            'prize' => $reward,
            'users' => $max_users,
            'admin' => $user_id
        ];
        $res = apiCall($data);

        if ($res['ok']) {
            sendMsg($chat_id, "🎁 <b>New Gift Code Generated!</b>\n\n🔐 Code: <b>$code</b>\n💰 Reward: <b>$reward MEGA</b>\n👥 Max Users: <b>$max_users</b>\n🕒 Generated at: " . date("Y-m-d H:i") . "\n\nUse this code wisely and share it with eligible users!");
        } else {
            sendMsg($chat_id, "❌ <b>Error!</b>\n" . $res['message']);
        }
        exit;
    }

    // /history
    if ($command === "/history") {
        global $admin_pin;
        $data = [
            'action' => 'get',
            'admin_password' => $admin_pin
        ];
        $res = apiCall($data);

        if ($res['ok']) {
            $history = $res['result'];
            $msg = "📘 <b>Your Code History</b>\n\n";

            foreach ($history as $entry) {
                if (($entry["admin"] ?? 0) == $user_id) {
                    $claimed = ($entry["initial_users"] ?? 0) - ($entry["users"] ?? 0);
                    $msg .= "• <b>".($entry["gift_code"] ?? "")."</b>\n".
                            "  🕒 Created: ".date("Y-m-d H:i", strtotime($entry["created_at"] ?? time()))."\n".
                            "  ✅ Claimed: ".$claimed."/".($entry["initial_users"] ?? 0)."\n\n";
                }
            }

            if ($msg === "📘 <b>Your Code History</b>\n\n") {
                $msg = "📭 <b>No codes generated yet.</b>\n\nUse /newcode to create your first gift code!";
            }

            sendMsg($chat_id, $msg);
        } else {
            sendMsg($chat_id, "❌ <b>Error!</b>\n" . $res['message']);
        }
        exit;
    }

    // /stats (super admin only)
    if ($command === "/stats") {
        if ($user_id != $super_admin) {
            sendMsg($chat_id, "❌ <b>Access Denied!</b>\nOnly super admin can access /stats.");
            exit;
        }

        global $admin_pin;
        $data = [
            'action' => 'get',
            'admin_password' => $admin_pin
        ];
        $res = apiCall($data);

        if ($res['ok']) {
            $history = $res['result'];
            $admins_stats = [];

            foreach ($history as $h) {
                $id = $h["admin"] ?? 0;
                if (!isset($admins_stats[$id])) $admins_stats[$id] = ["count" => 0, "claimed" => 0];
                $admins_stats[$id]["count"]++;
                $admins_stats[$id]["claimed"] += ($h["initial_users"] ?? 0) - ($h["users"] ?? 0);
            }

            $msg = "📊 <b>Mega Bot Stats</b>\n\n";
            foreach ($admins_stats as $id => $s) {
                $msg .= "🧑 Admin: $id | Total Codes: ".$s["count"]." | Users Claimed: ".$s["claimed"]."\n";
            }

            if (empty($admins_stats)) $msg .= "📭 No codes have been generated yet.";

            sendMsg($chat_id, $msg);
        } else {
            sendMsg($chat_id, "❌ <b>Error!</b>\n" . $res['message']);
        }
        exit;
    }

    // Unknown command for admins
    sendMsg($chat_id, "❌ <b>Unknown command!</b>\nUse /start to see available commands.");
    exit;
} else {
    // Non-command input: attempt to redeem code
    redeemCode($text, $user_id, $chat_id, $username);
    exit;
}
?>
