<?php

class Bot {
    private static $token;
    private static $apiUrl = 'https://api.telegram.org/bot';
    public static $chatId = null;
    public static $update = null;
    public static $command = null;
    public static $queryId = null;
    public static $params = null;

    /**
     * Initialize the bot with token and process incoming update
     * @param string $token Telegram Bot Token
     * @param array $update Optional raw update data
     */
    public static function init($token, $update = null) {
        self::$token = $token;

        if ($update === null) {
            $update = json_decode(file_get_contents('php://input'), true);
        }

        self::$update = $update;

        // Extract chatId, command, and params from update
        if (isset($update['message']['chat']['id'])) {
            self::$chatId = $update['message']['chat']['id'];
            if (isset($update['message']['text'])) {
                $text = $update['message']['text'];
                // Split text into command and parameters
                $parts = preg_split('/\s+/', $text, 2);
                self::$command = $parts[0] ?? null;
                self::$params = isset($parts[1]) ? trim($parts[1]) : null;
            } else {
                self::$command = null;
                self::$params = null;
            }
        } elseif (isset($update['callback_query'])) {
            self::$chatId = $update['callback_query']['message']['chat']['id'];
            if (isset($update['callback_query']['data'])) {
                $data = $update['callback_query']['data'];
                // Split callback data into command and parameters
                $parts = preg_split('/\s+/', $data, 2);
                self::$command = $parts[0] ?? null;
                self::$params = isset($parts[1]) ? trim($parts[1]) : null;
            } else {
                self::$command = null;
                self::$params = null;
            }
            self::$queryId = $update['callback_query']['id'] ?? null;
        } elseif (isset($update['pre_checkout_query'])) {
            self::$chatId = $update['pre_checkout_query']['from']['id'] ?? null;
            self::$command = null;
            self::$params = null;
        }
    }

    /**
     * Magic method to handle all Telegram API method calls
     * @param string $method API method name
     * @param array $params Parameters for the API call
     * @return mixed API response
     */
    public static function __callStatic($method, $params) {
        if (!self::$token) {
            throw new Exception('Bot not initialized. Please call Bot::init() first.');
        }

        // Get parameters from the first argument
        $data = !empty($params) ? $params[0] : [];

        // Add chat_id if not set and available
        if (!isset($data['chat_id']) && self::$chatId) {
            $data['chat_id'] = self::$chatId;
        }

        // JSON-encode specific parameters that require it (e.g., prices, reply_markup)
        foreach (['prices', 'reply_markup'] as $key) {
            if (isset($data[$key]) && is_array($data[$key])) {
                $data[$key] = json_encode($data[$key]);
            }
        }

        // Make HTTP POST request to Telegram API
        $url = self::$apiUrl . self::$token . '/' . $method;
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($data),
            CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded']
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode !== 200) {
            throw new Exception('Telegram API error: ' . $response);
        }

        $result = json_decode($response, true);
        if (!$result['ok']) {
            throw new Exception('Telegram API error: ' . $result['description']);
        }

        return $result['result'];
    }
}

?>